/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring;

import apmon.ApMon;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTReaderSession;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.FDTWriterSession;
import lia.util.net.copy.monitoring.FDTReportingTask;
import lia.util.net.copy.monitoring.FDTSessionMonitoringTask;

public class ApMonReportingTask
extends FDTReportingTask {
    private static final Logger logger = Logger.getLogger("lia.util.net.copy.monitoring.ApMonReportingTask");
    private static final ApMon apMon;

    private static final void sendParams(HashMap<String, HashMap<String, Double>> paramsToSend, String clusterName) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, " Sending to ApMonReportingTask :- ClusterName: " + clusterName + " Params: " + paramsToSend);
        }
        if (paramsToSend.size() > 0) {
            for (Map.Entry<String, HashMap<String, Double>> entry : paramsToSend.entrySet()) {
                HashMap<String, Double> hToSend = entry.getValue();
                Vector<Double> paramValues = null;
                Vector<String> paramNames = null;
                Vector<Integer> paramTypes = null;
                if (hToSend.size() > 0) {
                    paramValues = new Vector<Double>(hToSend.size());
                    paramNames = new Vector<String>(hToSend.size());
                    paramTypes = new Vector<Integer>(hToSend.size());
                    for (Map.Entry<String, Double> pEntry : hToSend.entrySet()) {
                        paramValues.add(pEntry.getValue());
                        paramNames.add(pEntry.getKey());
                        paramTypes.add(5);
                    }
                }
                if (paramValues == null) continue;
                apMon.sendParameters(clusterName, entry.getKey(), paramValues.size(), paramNames, paramTypes, paramValues);
            }
        }
    }

    private void publisStartFinishParams(FDTSession fdtSession) {
        block20: {
            if (fdtSession != null) {
                try {
                    HashMap paramsToSend = new HashMap();
                    HashMap<String, Double> fdtSessionParams = new HashMap<String, Double>();
                    FDTSessionMonitoringTask fdtSessionMTask = fdtSession.getMonitoringTask();
                    String apMonClusterName = "N/A";
                    if (fdtSessionMTask != null) {
                        String monID;
                        double cSize;
                        double tSize;
                        double rate;
                        if (fdtSession instanceof FDTWriterSession) {
                            rate = fdtSessionMTask.getTotalRate() / 1048576.0;
                            fdtSessionParams.put("DISK_WRITE_MB", rate);
                            tSize = (double)fdtSession.getSize() / 1048576.0;
                            cSize = (double)fdtSession.getTotalBytes() / 1048576.0;
                            fdtSessionParams.put("TotalMBytes", tSize);
                            fdtSessionParams.put("TransferredMBytes", cSize);
                            fdtSessionParams.put("Status", Double.valueOf(fdtSession.getCurrentStatus()));
                            if (fdtSession.getSize() != 0L) {
                                fdtSessionParams.put("TransferRatio", cSize * 100.0 / tSize);
                            }
                            if ((monID = fdtSession.getMonID()) != null) {
                                paramsToSend.put(monID, fdtSessionParams);
                            } else {
                                paramsToSend.put(fdtSession.getRemoteAddress().getHostAddress() + ":" + fdtSession.getRemotePort(), fdtSessionParams);
                            }
                            apMonClusterName = "Readers";
                        } else if (fdtSession instanceof FDTReaderSession) {
                            rate = fdtSessionMTask.getTotalRate() / 1048576.0;
                            fdtSessionParams.put("DISK_READ_MB", rate);
                            tSize = (double)fdtSession.getSize() / 1048576.0;
                            cSize = (double)fdtSession.getTotalBytes() / 1048576.0;
                            fdtSessionParams.put("TotalMBytes", tSize);
                            fdtSessionParams.put("TransferredMBytes", cSize);
                            if (fdtSession.getSize() != 0L) {
                                fdtSessionParams.put("TransferRatio", cSize * 100.0 / tSize);
                            }
                            fdtSessionParams.put("Status", Double.valueOf(fdtSession.getCurrentStatus()));
                            monID = fdtSession.getMonID();
                            if (monID != null) {
                                paramsToSend.put(monID, fdtSessionParams);
                            } else {
                                paramsToSend.put(fdtSession.getRemoteAddress().getHostAddress() + ":" + fdtSession.getRemotePort(), fdtSessionParams);
                            }
                            apMonClusterName = "Writers";
                        } else {
                            logger.log(Level.WARNING, "[ERROR] FDT Session is not an \"instanceof\" FDTWriterSession or FDTReaderSession!!!");
                            return;
                        }
                        if (paramsToSend.size() > 0) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, " Sending to ApMonReportingTask :- " + apMonClusterName + " Params: " + paramsToSend);
                            }
                            for (Map.Entry entry : paramsToSend.entrySet()) {
                                HashMap hToSend = (HashMap)entry.getValue();
                                Vector paramValues = null;
                                Vector paramNames = null;
                                Vector<Integer> paramTypes = null;
                                if (hToSend.size() > 0) {
                                    paramValues = new Vector(hToSend.size());
                                    paramNames = new Vector(hToSend.size());
                                    paramTypes = new Vector<Integer>(hToSend.size());
                                    for (Map.Entry pEntry : hToSend.entrySet()) {
                                        paramValues.add(pEntry.getValue());
                                        paramNames.add(pEntry.getKey());
                                        paramTypes.add(5);
                                    }
                                }
                                if (paramValues == null) continue;
                                apMon.sendParameters(apMonClusterName, (String)entry.getKey(), paramValues.size(), paramNames, paramTypes, paramValues);
                            }
                        }
                        break block20;
                    }
                    logger.log(Level.WARNING, "[ERROR] FDTSessionMonitoringTask is null in finishFDTSession(fdtSession)!!!");
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Got expcetion notifying last params for " + fdtSession.sessionID(), t);
                }
            } else {
                logger.log(Level.WARNING, "[ERROR] FDT Session is null in finishFDTSession(fdtSession)!!!");
            }
        }
    }

    @Override
    public void startFDTSession(FDTSession fdtSession) {
        this.publisStartFinishParams(fdtSession);
    }

    @Override
    public void finishFDTSession(FDTSession fdtSession) {
        this.publisStartFinishParams(fdtSession);
    }

    @Override
    public void run() {
        try {
            HashMap<String, HashMap<String, Double>> paramsToSend;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "ApMonReportingTask entering run()");
            }
            if ((paramsToSend = this.getReaderParams()).size() > 0) {
                ApMonReportingTask.sendParams(paramsToSend, "Readers");
            }
            paramsToSend = this.getWriterParams();
            double totalNet = 0.0;
            double totalDisk = 0.0;
            if (paramsToSend.size() > 0) {
                for (Map.Entry<String, HashMap<String, Double>> entry : paramsToSend.entrySet()) {
                    HashMap<String, Double> hToSend = entry.getValue();
                    if (hToSend.size() <= 0) continue;
                    Double dToAdd = hToSend.get("NET_IN_Mb");
                    if (dToAdd != null) {
                        totalNet += dToAdd.doubleValue();
                    }
                    if ((dToAdd = hToSend.get("DISK_WRITE_MB")) == null) continue;
                    totalDisk += dToAdd.doubleValue();
                }
            }
            if (paramsToSend.size() > 0) {
                ApMonReportingTask.sendParams(paramsToSend, "Writers");
            }
            if (Config.getInstance().getHostName() == null) {
                HashMap<String, Double> localParams = new HashMap<String, Double>();
                localParams.put("CLIENTS_NO", Double.valueOf(paramsToSend.size()));
                localParams.put("DISK_WRITE_MB", totalDisk);
                localParams.put("NET_IN_Mb", totalNet);
            }
        }
        catch (Throwable t) {
            logger.log(Level.INFO, " LISAReportingTask got exception:", t);
        }
    }

    static {
        ApMon apMonInstace = null;
        try {
            System.out.println("Starting ApMonReportingTask ...");
            apMonInstace = Utils.getApMon();
            System.out.println("ApMonReportingTask started!");
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Got exception getting apmon instance", t);
        }
        apMon = apMonInstace;
    }
}

