/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.jmx;

import java.util.Arrays;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import lia.util.net.common.DirectByteBufferPool;
import lia.util.net.copy.monitoring.jmx.DBPoolJMXMBean;

public class DBPoolJMX
extends StandardMBean
implements DBPoolJMXMBean {
    private final DirectByteBufferPool theRef;

    public DBPoolJMX(DirectByteBufferPool theRef) throws NotCompliantMBeanException {
        super(DBPoolJMXMBean.class);
        this.theRef = theRef;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "DBPoolJMX Description";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String description = null;
        if (info.getName().equals("BufferSize")) {
            description = "Size (in bytes) of the payload buffer in the buffer pool";
        } else if (info.getName().equals("Capacity")) {
            description = "Total number of buffers allocated";
        } else if (info.getName().equals("Instance")) {
            description = "Attribute exposed for management";
        } else if (info.getName().equals("Size")) {
            description = "Number of buffers available in the pool. Just to check leaks in the server. Should have the same value as Capacity when no active connections.";
        }
        return description;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("totalAllocated")) {
            switch (sequence) {
                default: 
            }
            return null;
        }
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("totalAllocated")) {
            switch (sequence) {
                default: 
            }
            return null;
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        MBeanParameterInfo[] params = info.getSignature();
        Object[] signature = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            signature[i] = params[i].getType();
        }
        Object[] methodSignature = new String[]{};
        if (info.getName().equals("totalAllocated") && Arrays.equals(signature, methodSignature)) {
            description = "Total allocated bytes allocated in NIO buffers. Another cross check. Should be Capacity x Buffer size.";
        }
        return description;
    }

    @Override
    public int getBufferSize() {
        return this.theRef.getBufferSize();
    }

    @Override
    public int getCapacity() {
        return this.theRef.getCapacity();
    }

    @Override
    public int getSize() {
        return this.theRef.getSize();
    }

    @Override
    public long totalAllocated() {
        return this.theRef.totalAllocated();
    }
}

