/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa.net.netstat;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lia.util.net.copy.monitoring.lisa.cmdExec;
import lia.util.net.copy.monitoring.lisa.net.PatternUtil;
import lia.util.net.copy.monitoring.lisa.net.netstat.Connection;

public class NetstatHandler {
    protected final PrintStream out;
    protected final cmdExec exec;
    protected final String netstatPattern = "\\S+\\s+\\d+\\s+\\d+\\s*(\\d*[\\.:]\\d*[\\.:]\\d*\\.*\\d*):(\\d+)\\s*(\\d*[\\.:]\\d*[\\.:]\\d*\\.*\\d*):([\\d\\*]+)\\s*([a-zA-Z]*)\\s*(\\d+)\\s*\\d+\\s*([\\d-]+)/*(\\S*)";
    protected final Logger logger;
    protected boolean netstatPathSetup = false;
    protected String netstatPath = null;

    public NetstatHandler(PrintStream out, Logger logger) {
        this.logger = logger;
        this.out = out;
        this.exec = cmdExec.getInstance();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            System.out.println("Start");
            NetstatHandler n = new NetstatHandler(System.out, null);
            List<Connection> c = n.getConnections();
            for (Connection conn : c) {
                System.out.println(conn);
            }
            System.out.println("end");
        }
    }

    private final synchronized String getNetstatPath() {
        String path = System.getProperty("net.netstat.path", "/bin,/sbin,/usr/bin,/usr/sbin");
        if (path != null && path.length() != 0) {
            path = path.replace(',', ':').trim();
        }
        return path;
    }

    private final String getPUID(String uid) {
        String pat = "([\\S&&[^:]]+):[\\S&&[^:]]+:" + uid + ":";
        Pattern pattern = PatternUtil.getPattern("uid_" + uid, pat);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("/etc/passwd"));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                return matcher.group(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "UNKNOWN";
    }

    private final boolean shouldRunNetstatTool() {
        String prop = System.getProperty("net.netstat.use", null);
        if (prop == null) {
            return true;
        }
        try {
            return Boolean.getBoolean(prop);
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    private final boolean shouldRunNetstatDevTool() {
        String prop = System.getProperty("net.netstat_dev.use", null);
        if (prop == null) {
            return true;
        }
        try {
            return Boolean.getBoolean(prop);
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public final List<Connection> getConnections() {
        String pname;
        String pid;
        String uid;
        String state;
        String remotePort;
        String remoteAddress;
        String localPort;
        Connection c;
        Matcher matcher;
        int i;
        if (!this.shouldRunNetstatTool()) {
            return null;
        }
        ArrayList<Connection> net = new ArrayList<Connection>();
        String netp = this.getNetstatPath();
        cmdExec.CommandResult cmdRes = this.exec.executeCommandReality("netstat -antep", null, 300000L, netp);
        String ret = cmdRes.getOutput();
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
                this.out.println("Error running netstat");
            } else {
                this.logger.info(ret);
                this.logger.info("Error running netstat");
            }
            return null;
        }
        Pattern pattern = PatternUtil.getPattern("netstat", "\\S+\\s+\\d+\\s+\\d+\\s*(\\d*[\\.:]\\d*[\\.:]\\d*\\.*\\d*):(\\d+)\\s*(\\d*[\\.:]\\d*[\\.:]\\d*\\.*\\d*):([\\d\\*]+)\\s*([a-zA-Z]*)\\s*(\\d+)\\s*\\d+\\s*([\\d-]+)/*(\\S*)");
        String[] lines = ret.split("\n");
        for (i = 0; i < lines.length; ++i) {
            matcher = pattern.matcher(lines[i]);
            if (!matcher.find()) continue;
            c = new Connection();
            net.add(c);
            c.setProtocol((byte)0);
            localPort = matcher.group(2);
            remoteAddress = matcher.group(3);
            remotePort = matcher.group(4);
            state = matcher.group(5);
            uid = matcher.group(6);
            pid = matcher.group(7);
            pname = matcher.group(8);
            c.setPOwner(this.getPUID(uid));
            try {
                c.setPID(Integer.parseInt(pid));
            }
            catch (Exception ex) {
                c.setPID(-1);
            }
            c.setPName(pname);
            try {
                c.setLocalPort(Integer.parseInt(localPort));
            }
            catch (Exception ex) {
                c.setLocalPort(0);
            }
            c.setRemoteAddress(remoteAddress);
            try {
                c.setRemotePort(Integer.parseInt(remotePort));
            }
            catch (Exception ex) {
                c.setRemotePort(0);
            }
            c.setStatus(state);
        }
        cmdRes = this.exec.executeCommandReality("netstat -anuep", null, 300000L, netp);
        ret = cmdRes.getOutput();
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
                this.out.println("Error running netstat");
            } else {
                this.logger.info(ret);
                this.logger.info("Error running netstat");
            }
            return net;
        }
        lines = ret.split("\n");
        for (i = 0; i < lines.length; ++i) {
            matcher = pattern.matcher(lines[i]);
            if (!matcher.find()) continue;
            c = new Connection();
            net.add(c);
            c.setProtocol((byte)1);
            localPort = matcher.group(2);
            remoteAddress = matcher.group(3);
            remotePort = matcher.group(4);
            state = matcher.group(5);
            uid = matcher.group(6);
            pid = matcher.group(7);
            pname = matcher.group(8);
            c.setPOwner(this.getPUID(uid));
            try {
                c.setPID(Integer.parseInt(pid));
            }
            catch (Exception ex) {
                c.setPID(-1);
            }
            c.setPName(pname);
            try {
                c.setLocalPort(Integer.parseInt(localPort));
            }
            catch (Exception ex) {
                c.setLocalPort(0);
            }
            c.setRemoteAddress(remoteAddress);
            try {
                c.setRemotePort(Integer.parseInt(remotePort));
            }
            catch (Exception ex) {
                c.setRemotePort(0);
            }
            c.setStatus(state);
        }
        cmdRes = this.exec.executeCommandReality("netstat -anwep", null, 300000L, netp);
        ret = cmdRes.getOutput();
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
                this.out.println("Error running netstat");
            } else {
                this.logger.info(ret);
                this.logger.info("Error running netstat");
            }
            return net;
        }
        lines = ret.split("\n");
        for (i = 0; i < lines.length; ++i) {
            matcher = pattern.matcher(lines[i]);
            if (!matcher.find()) continue;
            c = new Connection();
            net.add(c);
            c.setProtocol((byte)2);
            localPort = matcher.group(2);
            remoteAddress = matcher.group(3);
            remotePort = matcher.group(4);
            state = matcher.group(5);
            uid = matcher.group(6);
            pid = matcher.group(7);
            pname = matcher.group(8);
            c.setPOwner(this.getPUID(uid));
            try {
                c.setPID(Integer.parseInt(pid));
            }
            catch (Exception ex) {
                c.setPID(-1);
            }
            c.setPName(pname);
            try {
                c.setLocalPort(Integer.parseInt(localPort));
            }
            catch (Exception ex) {
                c.setLocalPort(0);
            }
            c.setRemoteAddress(remoteAddress);
            try {
                c.setRemotePort(Integer.parseInt(remotePort));
            }
            catch (Exception ex) {
                c.setRemotePort(0);
            }
            c.setStatus(state);
        }
        return net;
    }
}

