/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa.net.statistics;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.copy.monitoring.lisa.net.statistics.IPStatistics;
import lia.util.net.copy.monitoring.lisa.net.statistics.TCPExtStatistics;
import lia.util.net.copy.monitoring.lisa.net.statistics.TCPStatistics;
import lia.util.net.copy.monitoring.lisa.net.statistics.UDPStatistics;

public class StatisticsHandler {
    static final NumberFormat nf = NumberFormat.getInstance();
    protected final PrintStream out;
    protected final Logger logger;
    private final HashMap<String, TreeMap<Long, String>> lastValues = new HashMap();
    private IPStatistics ipStatistics = null;
    private TCPStatistics tcpStatistics = null;
    private UDPStatistics udpStatistics = null;
    private TCPExtStatistics tcpExtStatistics = null;
    private boolean is64BitArch = false;

    public StatisticsHandler(PrintStream out, Logger logger) {
        this.out = out;
        this.logger = logger;
    }

    public static void main(String[] args) {
        StatisticsHandler h = new StatisticsHandler(System.out, null);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        double d = h.getInstantValue("test", 1000L, "105395052");
        d = h.getInstantValue("test", 6000L, "105395986");
        System.out.println(nf.format(d));
    }

    private final int getValueAsInt(String val) {
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private final long getValueAsLong(String val) {
        try {
            return Long.parseLong(val.trim());
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public final double getInstantValue(String key, long time, String newVal) {
        TreeMap<Object, Object> h = null;
        if (!this.lastValues.containsKey(key)) {
            h = new TreeMap();
            this.lastValues.put(key, h);
        } else {
            h = this.lastValues.get(key);
        }
        if (h.size() == 0) {
            h.put(time, newVal);
            return 0.0;
        }
        if (h.size() == 2) {
            h.remove(h.firstKey());
        }
        h.put(time, newVal);
        long first = (Long)h.firstKey();
        long last = (Long)h.lastKey();
        String s1 = (String)h.get(first);
        String s2 = (String)h.get(last);
        double d = 0.0;
        try {
            d = Double.parseDouble(this.diffWithOverflowCheck(s2, s1));
        }
        catch (Throwable t) {
            d = 0.0;
        }
        return d /= (double)(last - first) / 1000.0;
    }

    private final boolean getBooleanOf(String val) {
        return this.getValueAsInt(val) == 2;
    }

    private final IPStatistics parseIPTable(String headerLine, String valuesLine, IPStatistics ipstat) {
        IPStatistics stat = ipstat != null ? ipstat : new IPStatistics();
        StringTokenizer tok = new StringTokenizer(headerLine);
        StringTokenizer valTok = new StringTokenizer(valuesLine);
        try {
            String valEl;
            String el;
            while ((el = tok.nextToken(" \t\n")) != null && (valEl = valTok.nextToken(" \t\n")) != null) {
                if (el.equals("Forwarding")) {
                    stat.setForwarding(this.getBooleanOf(valEl));
                    continue;
                }
                if (el.equals("DefaultTTL")) {
                    stat.setDefaultTTL(this.getValueAsLong(valEl));
                    continue;
                }
                if (el.equals("InReceives")) {
                    stat.setInReceived(valEl, this.getInstantValue("InReceives", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("InHdrErrors")) {
                    stat.setInHdrErrors(valEl, this.getInstantValue("InHdrErrors", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("InAddrErrors")) {
                    stat.setInAddrErrors(valEl, this.getInstantValue("InAddrErrors", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("ForwDatagrams")) {
                    stat.setForwDatagrams(valEl, this.getInstantValue("ForwDatagrams", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("InUnknownProtos")) {
                    stat.setInUnknownProtos(valEl, this.getInstantValue("InUnknownProtos", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("InDiscards")) {
                    stat.setInDiscards(valEl, this.getInstantValue("InDiscards", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("InDelivers")) {
                    stat.setInDelivers(valEl, this.getInstantValue("InDelivers", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("OutRequests")) {
                    stat.setOutRequests(valEl, this.getInstantValue("OutRequest", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("OutDiscards")) {
                    stat.setOutDiscards(valEl, this.getInstantValue("OutDiscards", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("OutNoRoutes")) {
                    stat.setOutNoRoutes(valEl, this.getInstantValue("OutNoRoutes", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("ReasmTimeout")) {
                    stat.setReasmTimeout(valEl, this.getInstantValue("ReasmTimeout", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("ReasmReqds")) {
                    stat.setReasmReqds(valEl, this.getInstantValue("ReasmReqds", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("ReasmOKs")) {
                    stat.setReasmOKs(valEl, this.getInstantValue("ReasmsOKs", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("ReasmFails")) {
                    stat.setReasmFails(valEl, this.getInstantValue("ReasmFails", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("FragOKs")) {
                    stat.setFragOKs(valEl, this.getInstantValue("FragOKs", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("FragFails")) {
                    stat.setFragFails(valEl, this.getInstantValue("FragFails", stat.getTime(), valEl));
                    continue;
                }
                if (!el.equals("FragCreates")) continue;
                stat.setFragCreates(valEl, this.getInstantValue("FragCreates", stat.getTime(), valEl));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return stat;
    }

    private final TCPStatistics parseTCPTable(String headerLine, String valuesLine, TCPStatistics tcpstat) {
        TCPStatistics stat = tcpstat != null ? tcpstat : new TCPStatistics();
        StringTokenizer tok = new StringTokenizer(headerLine);
        StringTokenizer valTok = new StringTokenizer(valuesLine);
        try {
            String valEl;
            String el;
            while ((el = tok.nextToken(" \t\n")) != null && (valEl = valTok.nextToken(" \t\n")) != null) {
                if (el.equals("RtoMin")) {
                    stat.setRToMin(this.getValueAsLong(valEl));
                    continue;
                }
                if (el.equals("RtoMax")) {
                    stat.setRToMax(this.getValueAsLong(valEl));
                    continue;
                }
                if (el.equals("ActiveOpens")) {
                    stat.setActiveOpens(valEl, this.getInstantValue("ActiveOpens", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("PassiveOpens")) {
                    stat.setPassiveOpens(valEl, this.getInstantValue("PassiveOpens", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("AttemptFails")) {
                    stat.setAttemptFails(valEl, this.getInstantValue("AttemptFails", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("EstabResets")) {
                    stat.setEstabResets(valEl, this.getInstantValue("EstabResets", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("CurrEstab")) {
                    stat.setCurrEstab(this.getValueAsLong(valEl));
                    continue;
                }
                if (el.equals("InSegs")) {
                    stat.setInSegs(valEl, this.getInstantValue("InSegs", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("OutSegs")) {
                    stat.setOutSegs(valEl, this.getInstantValue("OutSegs", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("RetransSegs")) {
                    stat.setRetransSegs(valEl, this.getInstantValue("RetransSegs", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("InErrs")) {
                    stat.setInErrs(valEl, this.getInstantValue("InErrs", stat.getTime(), valEl));
                    continue;
                }
                if (!el.equals("OutRsts")) continue;
                stat.setOutRsts(valEl, this.getInstantValue("OutRsts", stat.getTime(), valEl));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return stat;
    }

    private final UDPStatistics parseUDPTable(String headerLine, String valuesLine, UDPStatistics udpstat) {
        UDPStatistics stat = udpstat != null ? udpstat : new UDPStatistics();
        StringTokenizer tok = new StringTokenizer(headerLine);
        StringTokenizer valTok = new StringTokenizer(valuesLine);
        try {
            String valEl;
            String el;
            while ((el = tok.nextToken(" \t\n")) != null && (valEl = valTok.nextToken(" \t\n")) != null) {
                if (el.equals("InDatagrams")) {
                    stat.setInDatagrams(valEl, this.getInstantValue("InDatagrams", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("NoPorts")) {
                    stat.setNoPorts(valEl, this.getInstantValue("NoPorts", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("InErrors")) {
                    stat.setInErrors(valEl, this.getInstantValue("InErrors", stat.getTime(), valEl));
                    continue;
                }
                if (!el.equals("OutDatagrams")) continue;
                stat.setOutDatagrams(valEl, this.getInstantValue("OutDatagrams", stat.getTime(), valEl));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return stat;
    }

    private final TCPExtStatistics parseExtendedTCPTable(String headerLine, String valuesLine, TCPExtStatistics tcpstat) {
        TCPExtStatistics stat = tcpstat != null ? tcpstat : new TCPExtStatistics();
        StringTokenizer tok = new StringTokenizer(headerLine);
        StringTokenizer valTok = new StringTokenizer(valuesLine);
        try {
            String valEl;
            String el;
            while ((el = tok.nextToken(" \t\n")) != null && (valEl = valTok.nextToken(" \t\n")) != null) {
                if (el.equals("SyncookiesSent")) {
                    stat.setSyncookiesSent(valEl, this.getInstantValue("SyncookiesSent", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("SyncookiesRecv")) {
                    stat.setSyncookiesRecv(valEl, this.getInstantValue("SyncookiesRecv", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("SyncookiesFailed")) {
                    stat.setSyncookiesFailed(valEl, this.getInstantValue("SyncookiesFailed", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("EmbryonicRsts")) {
                    stat.setEmbryonicRsts(valEl, this.getInstantValue("EmbryonicRsts", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("PruneCalled")) {
                    stat.setPruneCalled(valEl, this.getInstantValue("PruneCalled", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("RcvPruned")) {
                    stat.setRcvPruned(valEl, this.getInstantValue("RcvPruned", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("OfoPruned")) {
                    stat.setOfoPruned(valEl, this.getInstantValue("OfoPruned", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TW")) {
                    stat.setTW(valEl, this.getInstantValue("TW", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TWRecycled")) {
                    stat.setTWRecycled(valEl, this.getInstantValue("TWRecycled", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TWKilled")) {
                    stat.setTWKilled(valEl, this.getInstantValue("TWKilled", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("PAWSPassive")) {
                    stat.setPAWSPassive(valEl, this.getInstantValue("PAWSPassive", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("PAWSActive")) {
                    stat.setPAWSActive(valEl, this.getInstantValue("PAWSActive", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("PAWSEstab")) {
                    stat.setPAWSEstab(valEl, this.getInstantValue("PAWEstab", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("DelayedACKs")) {
                    stat.setDelayedACKs(valEl, this.getInstantValue("DelayedACKs", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("DelayedACKLocked")) {
                    stat.setDelayedACKLocked(valEl, this.getInstantValue("DelayedACKLocked", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("DelayedACKLost")) {
                    stat.setDelayedACKLost(valEl, this.getInstantValue("DelayedACKLost", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("ListenOverflows")) {
                    stat.setListenOverflows(valEl, this.getInstantValue("ListenOverflows", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("ListenDrops")) {
                    stat.setListenDrops(valEl, this.getInstantValue("ListenDrops", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPPrequeued")) {
                    stat.setTCPPrequeued(valEl, this.getInstantValue("TCPPrequeued", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPDirectCopyFromBacklog")) {
                    stat.setTCPDirectCopyFromBacklog(valEl, this.getInstantValue("TCPDirectCopyFromBacklog", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPDirectCopyFromPrequeue")) {
                    stat.setTCPDirectCopyFromPrequeue(valEl, this.getInstantValue("TCPDirectCopyFromPrequeue", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPPrequeueDropped")) {
                    stat.setTCPPrequeueDropped(valEl, this.getInstantValue("TCPPrequeueDropped", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPHPHits")) {
                    stat.setTCPHPHits(valEl, this.getInstantValue("TCPHPHits", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPHPHitsToUser")) {
                    stat.setTCPHPHitsToUser(valEl, this.getInstantValue("TCPHPHitsToUser", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("SockMallocOOM")) {
                    stat.setSockMallocOOM(valEl, this.getInstantValue("SockMallocOOM", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPPureAcks")) {
                    stat.setTCPPureAcks(valEl, this.getInstantValue("TCPPureAcks", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPHPAcks")) {
                    stat.setTCPHPAcks(valEl, this.getInstantValue("TCPHPAcks", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPRenoRecovery")) {
                    stat.setTCPRenoRecovery(valEl, this.getInstantValue("TCPRenoRecovery", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPSackRecovery")) {
                    stat.setTCPSackRecovery(valEl, this.getInstantValue("TCPSackRecovery", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPSACKReneging")) {
                    stat.setTCPSACKReneging(valEl, this.getInstantValue("TCPSACKReneging", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPFACKReorder")) {
                    stat.setTCPFACKReorder(valEl, this.getInstantValue("TCPFACKReorder", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPSACKReorder")) {
                    stat.setTCPSACKReorder(valEl, this.getInstantValue("TCPSACKReorder", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPRenoReorder")) {
                    stat.setTCPRenoReorder(valEl, this.getInstantValue("TCPRenoReorder", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPTSReorder")) {
                    stat.setTCPTSReorder(valEl, this.getInstantValue("TCPTSReorder", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPFullUndo")) {
                    stat.setTCPFullUndo(valEl, this.getInstantValue("TCPFullUndo", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPPartialUndo")) {
                    stat.setTCPPartialUndo(valEl, this.getInstantValue("TCPPartialUndo", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPDSACKUndo")) {
                    stat.setTCPDSACKUndo(valEl, this.getInstantValue("TCPDSACKUndo", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPLossUndo")) {
                    stat.setTCPLossUndo(valEl, this.getInstantValue("TCPLossUndo", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPLoss")) {
                    stat.setTCPLoss(valEl, this.getInstantValue("TCPLoss", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPLostRetransmit")) {
                    stat.setTCPLostRetransmit(valEl, this.getInstantValue("TCPLostRetransmit", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPRenoFailures")) {
                    stat.setTCPRenoFailures(valEl, this.getInstantValue("TCPRenoFailures", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPSackFailures")) {
                    stat.setTCPSackFailures(valEl, this.getInstantValue("TCPSackFailures", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPLossFailures")) {
                    stat.setTCPLossFailures(valEl, this.getInstantValue("TCPLossFailures", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPFastRetrans")) {
                    stat.setTCPFastRetrans(valEl, this.getInstantValue("TCPFastRetrans", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPForwardRetrans")) {
                    stat.setTCPForwardRetrans(valEl, this.getInstantValue("TCPForwardRetrans", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPSlowStartRetrans")) {
                    stat.setTCPSlowStartRetrans(valEl, this.getInstantValue("TCPSlowStartRetrans", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPTimeouts")) {
                    stat.setTCPTimeouts(valEl, this.getInstantValue("TCPTimeouts", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPRenoRecoveryFail")) {
                    stat.setTCPRenoRecoveryFail(valEl, this.getInstantValue("TCPRenoRecoveryFail", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPSackRecoveryFail")) {
                    stat.setTCPSackRecoveryFail(valEl, this.getInstantValue("TCPSackRecoveryFail", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPSchedulerFailed")) {
                    stat.setTCPSchedulerFailed(valEl, this.getInstantValue("TCPSchedulerFailed", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPRcvCollapsed")) {
                    stat.setTCPRcvCollapsed(valEl, this.getInstantValue("TCPRcvCollapsed", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPDSACKOldSent")) {
                    stat.setTCPDSACKOldSent(valEl, this.getInstantValue("TCPDSACKOldSent", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPDSACKOfoSent")) {
                    stat.setTCPDSACKOfoSent(valEl, this.getInstantValue("TCPDSACKOfoSent", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPDSACKRecv")) {
                    stat.setTCPDSACKRecv(valEl, this.getInstantValue("TCPDSACKRecv", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPDSACKOfoRecv")) {
                    stat.setTCPDSACKOfoRecv(valEl, this.getInstantValue("TCPDSACKOfoRecv", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPAbortOnSyn")) {
                    stat.setTCPAbortOnSyn(valEl, this.getInstantValue("TCPAbortOnSyn", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPAbortOnData")) {
                    stat.setTCPAbortOnData(valEl, this.getInstantValue("TCPAbortOnData", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPAbortOnClose")) {
                    stat.setTCPAbortOnClose(valEl, this.getInstantValue("TCPAbortOnClose", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPAbortOnMemory")) {
                    stat.setTCPAbortOnMemory(valEl, this.getInstantValue("TCPAbortOnMemory", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPAbortOnTimeout")) {
                    stat.setTCPAbortOnTimeout(valEl, this.getInstantValue("TCPAbortOnTimeout", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPAbortOnLinger")) {
                    stat.setTCPAbortOnLinger(valEl, this.getInstantValue("TCPAbortOnLinger", stat.getTime(), valEl));
                    continue;
                }
                if (el.equals("TCPAbortFailed")) {
                    stat.setTCPAbortFailed(valEl, this.getInstantValue("TCPAbortFailed", stat.getTime(), valEl));
                    continue;
                }
                if (!el.equals("TCPMemoryPressures")) continue;
                stat.setTCPMemoryPressures(valEl, this.getInstantValue("TCPMemoryPressures", stat.getTime(), valEl));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return stat;
    }

    public void getStatistics() {
        String values;
        String header;
        BufferedReader br;
        this.ipStatistics = null;
        this.tcpStatistics = null;
        this.udpStatistics = null;
        this.tcpExtStatistics = null;
        try {
            br = new BufferedReader(new FileReader("/proc/net/snmp"));
            while ((header = br.readLine()) != null && (values = br.readLine()) != null) {
                if (header.startsWith("Ip: ") && values.startsWith("Ip: ")) {
                    this.ipStatistics = this.parseIPTable(header.substring(4), values.substring(4), null);
                    if (!this.logger.isLoggable(Level.FINEST)) continue;
                    this.logger.log(Level.FINE, this.ipStatistics.toString());
                    continue;
                }
                if (header.startsWith("Tcp: ") && values.startsWith("Tcp: ")) {
                    this.tcpStatistics = this.parseTCPTable(header.substring(5), values.substring(5), null);
                    if (!this.logger.isLoggable(Level.FINEST)) continue;
                    this.logger.log(Level.FINE, this.tcpStatistics.toString());
                    continue;
                }
                if (!header.startsWith("Udp: ") || !values.startsWith("Udp: ")) continue;
                this.udpStatistics = this.parseUDPTable(header.substring(5), values.substring(5), null);
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.log(Level.FINE, this.udpStatistics.toString());
            }
            br.close();
        }
        catch (FileNotFoundException fne) {
            if (this.out != null) {
                this.out.println("File /proc/net/snmp not found.");
            } else {
                this.logger.info("File /proc/net/snmp not found.");
            }
        }
        catch (IOException ioe) {
            if (this.out != null) {
                this.out.println(ioe.getLocalizedMessage());
            }
            this.logger.warning(ioe.getLocalizedMessage());
        }
        try {
            br = new BufferedReader(new FileReader("/proc/net/netstat"));
            while ((header = br.readLine()) != null && (values = br.readLine()) != null) {
                if (!header.startsWith("TcpExt: ") || !values.startsWith("TcpExt: ")) continue;
                this.tcpExtStatistics = this.parseExtendedTCPTable(header.substring(8), values.substring(8), null);
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.log(Level.FINE, this.tcpExtStatistics.toString());
            }
            br.close();
        }
        catch (FileNotFoundException fne) {
            if (this.out != null) {
                this.out.println("File /proc/net/netstat not found.");
            } else {
                this.logger.info("File /proc/net/netstat not found.");
            }
        }
        catch (IOException ioe) {
            if (this.out != null) {
                this.out.println(ioe.getLocalizedMessage());
            }
            this.logger.warning(ioe.getLocalizedMessage());
        }
    }

    public final IPStatistics getIPStatistics() {
        return this.ipStatistics;
    }

    public final TCPStatistics getTCPStatistics() {
        return this.tcpStatistics;
    }

    public final UDPStatistics getUDPStatistics() {
        return this.udpStatistics;
    }

    public final TCPExtStatistics getTCPExtStatistics() {
        return this.tcpExtStatistics;
    }

    private final String prepareString(String str) {
        try {
            double d = Double.parseDouble(str);
            if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                String n = nf.format(d);
                n = n.replaceAll(",", "");
                return n;
            }
        }
        catch (Throwable d) {
            // empty catch block
        }
        if (!str.contains(".")) {
            return str + ".0000";
        }
        int nr = str.lastIndexOf(46) + 1;
        for (int i = nr = str.length() - nr; i < 4; ++i) {
            str = str + "0";
        }
        return str;
    }

    public String addWithOverflowCheck(String newVal, String oldVal) throws NumberFormatException {
        if (newVal == null) {
            return oldVal;
        }
        if (oldVal == null) {
            return newVal;
        }
        if (this.is64BitArch) {
            String str = this.prepareString(newVal);
            BigDecimal newv = null;
            try {
                newv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            str = this.prepareString(oldVal);
            BigDecimal oldv = null;
            try {
                oldv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            return newv.add(oldv).toString();
        }
        double toCompare = 4.294967296E9;
        double newv = Double.parseDouble(newVal);
        double oldv = Double.parseDouble(oldVal);
        if (newv >= toCompare || oldv >= toCompare) {
            this.is64BitArch = true;
            return this.addWithOverflowCheck(newVal, oldVal);
        }
        return "" + (newv + oldv);
    }

    public String divideWithOverflowCheck(String newVal, String oldVal) throws NumberFormatException {
        if (this.is64BitArch) {
            String str = this.prepareString(newVal);
            BigDecimal newv = null;
            try {
                newv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            str = this.prepareString(oldVal);
            BigDecimal oldv = null;
            try {
                oldv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            return newv.divide(oldv, 3).toString();
        }
        double toCompare = 4.294967296E9;
        double newv = Double.parseDouble(newVal);
        double oldv = Double.parseDouble(oldVal);
        if (newv >= toCompare || oldv >= toCompare) {
            this.is64BitArch = true;
            return this.divideWithOverflowCheck(newVal, oldVal);
        }
        return "" + newv / oldv;
    }

    public String mulWithOverflowCheck(String newVal, String oldVal) throws NumberFormatException {
        if (this.is64BitArch) {
            String str = this.prepareString(newVal);
            BigDecimal newv = null;
            try {
                newv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            str = this.prepareString(oldVal);
            BigDecimal oldv = null;
            try {
                oldv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            return newv.multiply(oldv).toString();
        }
        double toCompare = 4.294967296E9;
        double newv = Double.parseDouble(newVal);
        double oldv = Double.parseDouble(oldVal);
        if (newv >= toCompare || oldv >= toCompare) {
            this.is64BitArch = true;
            return this.mulWithOverflowCheck(newVal, oldVal);
        }
        return "" + newv * oldv;
    }

    public String diffWithOverflowCheck(String newVal, String oldVal) throws NumberFormatException {
        if (this.is64BitArch) {
            String str = this.prepareString(newVal);
            BigDecimal newv = null;
            try {
                newv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            str = this.prepareString(oldVal);
            BigDecimal oldv = null;
            try {
                oldv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            if (newv.compareTo(oldv) >= 0) {
                return newv.subtract(oldv).toString();
            }
            BigInteger overflow = new BigInteger("1").shiftLeft(64);
            BigDecimal d = new BigDecimal(overflow.toString());
            return newv.add(d).subtract(oldv).toString();
        }
        double toCompare = 4.294967296E9;
        double newv = Double.parseDouble(newVal);
        double oldv = Double.parseDouble(oldVal);
        if (newv >= toCompare || oldv >= toCompare) {
            this.is64BitArch = true;
            return this.diffWithOverflowCheck(newVal, oldVal);
        }
        if (newv >= oldv) {
            return "" + (newv - oldv);
        }
        long vmax = 0x100000000L;
        return "" + (newv - oldv + (double)vmax);
    }

    public void clear() {
        this.ipStatistics = null;
        this.tcpStatistics = null;
        this.udpStatistics = null;
        this.tcpExtStatistics = null;
    }

    static {
        nf.setMaximumFractionDigits(4);
        nf.setMinimumFractionDigits(4);
    }
}

