/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.jiperf;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import lia.util.net.jiperf.JIperfClient;
import lia.util.net.jiperf.JIperfServer;

public class JIperf {
    private static final transient Logger logger = Logger.getLogger(JIperf.class.getName());
    private static final ExecutorService executor;

    public static final ExecutorService getExecutor() {
        return executor;
    }

    public static final void shutdownExecutor() {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static HashMap<String, String> parseArguments(String[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        HashMap<String, String> rHM = new HashMap<String, String>();
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].startsWith("-")) continue;
            if (args[i + 1].startsWith("-")) {
                rHM.put(args[i], "");
                continue;
            }
            rHM.put(args[i], args[i + 1]);
            ++i;
        }
        if (args[args.length - 1].startsWith("-")) {
            rHM.put(args[args.length - 1], "");
        }
        return rHM;
    }

    public static void printHelp() {
        System.err.println("Usage:");
        System.err.println("\tServer");
        System.err.println("\t\tstandalone: java JIperf -s -p portNumer -P numberOfThreads -w windowSize");
        System.err.println("\t\tUse a SSH control connection: java JIperf -s -ssh");
        System.err.println("\tClient");
        System.err.println("\t\tstandalone: java JIperf -c host -p portNumer -P numberOfThreads -w windowSize");
        System.err.println("\t\tremotely start a jiperf server: java JIperf -c host -ssh [-u user] [-E command] -p portNumer -P numberOfThreads -w windowSize");
    }

    public static void main(String[] args) {
        try {
            HashMap<String, String> argsMap = JIperf.parseArguments(args);
            if (argsMap.containsKey("-c")) {
                JIperfClient client = new JIperfClient(argsMap);
                client.flood();
            } else if (argsMap.containsKey("-s")) {
                JIperfServer server = new JIperfServer(argsMap);
                server.doWork();
            } else {
                JIperf.printHelp();
                System.exit(0);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    static {
        ThreadPoolExecutor texecutor = new ThreadPoolExecutor(5, 20, 120L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            AtomicLong l = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, " JIperf Worker Task " + this.l.getAndIncrement());
            }
        });
        texecutor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    long SLEEP_TIME = Math.round(Math.random() * 1000.0 + 1.0);
                    try {
                        Thread.sleep(SLEEP_TIME);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    System.err.println("\n\n [ RejectedExecutionHandler ] slept for " + SLEEP_TIME);
                    executor.execute(r);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        texecutor.prestartAllCoreThreads();
        executor = texecutor;
    }
}

