/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.stores.ResourceCACertStore;
import org.globus.gsi.stores.ResourceCRLStore;
import org.globus.gsi.stores.ResourceCertStoreParameters;
import org.globus.gsi.stores.ResourceStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCertStore
extends CertStoreSpi {
    private static Log logger = LogFactory.getLog(ResourceCertStore.class.getCanonicalName());
    private ResourceCACertStore caDelegate = new ResourceCACertStore();
    private ResourceCRLStore crlDelegate = new ResourceCRLStore();

    public ResourceCertStore(CertStoreParameters params) throws InvalidAlgorithmParameterException, ResourceStoreException {
        super(params);
        if (params == null) {
            throw new InvalidAlgorithmParameterException();
        }
        if (!(params instanceof ResourceCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException();
        }
        ResourceCertStoreParameters storeParams = (ResourceCertStoreParameters)params;
        this.crlDelegate.loadWrappers(storeParams.getCrlLocationPattern());
        this.caDelegate.loadWrappers(storeParams.getCertLocationPattern());
    }

    @Override
    public Collection<? extends Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        logger.debug("selecting Certificates");
        if (selector != null && !(selector instanceof X509CertSelector)) {
            throw new IllegalArgumentException();
        }
        if (this.caDelegate.getCollection() == null) {
            return null;
        }
        Vector<X509Certificate> certSet = new Vector<X509Certificate>();
        if (selector == null) {
            for (TrustAnchor trustAnchor : this.caDelegate.getCollection()) {
                certSet.add(trustAnchor.getTrustedCert());
            }
        } else {
            for (TrustAnchor trustAnchor : this.caDelegate.getCollection()) {
                X509Certificate cert = trustAnchor.getTrustedCert();
                if (!selector.match(cert)) continue;
                certSet.add(cert);
            }
        }
        return certSet;
    }

    @Override
    public Collection<? extends CRL> engineGetCRLs(CRLSelector selector) throws CertStoreException {
        if (selector != null && !(selector instanceof X509CRLSelector)) {
            throw new IllegalArgumentException();
        }
        if (this.crlDelegate.getCollection() == null) {
            return new Vector();
        }
        if (selector == null) {
            return this.crlDelegate.getCollection();
        }
        Vector<X509CRL> certSet = new Vector<X509CRL>();
        for (X509CRL crl : this.crlDelegate.getCollection()) {
            if (!selector.match(crl)) continue;
            certSet.add(crl);
        }
        return certSet;
    }
}

