/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.globus.common.CoGProperties;
import org.globus.common.Version;
import org.globus.gsi.CertUtil;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.util.ConfigUtil;
import org.globus.util.PEMUtils;
import org.globus.util.Util;

public final class GridCertRequest {
    public static final String USAGE = "\n\ngrid-cert-request [-help] [ options ...]\n\n  Example Usage:\n\n    Creating a user certifcate:\n      grid-cert-request\n\n    Creating a host or gatekeeper certifcate:\n      grid-cert-request -host [my.host.fqdn]\n\n    Creating a LDAP server certificate:\n      grid-cert-request -service ldap -host [my.host.fqdn]\n\n  Options:\n\n    -version           : Display version\n    -?, -h, -help,     : Display usage\n    -usage\n    -cn <name>,        : Common name of the user\n    -commonname <name>\n    -service <service> : Create certificate for a service. Requires\n                         the -host option and implies that the generated\n                         key will not be password protected (ie implies -nopw).\n    -host <FQDN>       : Create certificate for a host named <FQDN>\n    -dir <directory>   : Changes the directory the private key and certificate\n                         request will be placed in. By default user certificates\n                         are placed in " + System.getProperty("user.home") + File.separator + ".globus\n                         directory. On Unix machines, host certificates are\n                         placed in /etc/grid-security directory and service\n                         certificates are placed in /etc/grid-security/<service>.\n                         On Windows machines they are placed in the same\n                         location as the user certificates.\n    -prefix <prefix>   : Causes the generated files to be named\n                         <prefix>cert.pem, <prefix>key.pem and\n                         <prefix>cert_request.pem\n    -nopw,             : Create certificate without a password\n    -nodes,\n    -nopassphrase,\n    -verbose           : Don't clear the screen <<Not used>>\n    -int[eractive]     : Prompt user for each component of the DN\n    -force             : Overwrites preexisting certifictes\n    -caEmail <address> : CA email address, if request is to be mailed to CA\n    -orgBaseDN <dn>    : The base DN of this organization (in LDAP format)";
    private static final String MESSAGE = "A certificate request and private key will be created.\nYou will be asked to enter a PEM pass phrase.\nThis pass phrase is akin to your account password,\nand is used to protect your key file.\nIf you forget your pass phrase, you will need to\nobtain a new certificate.\n";
    private static String caEmail = null;
    private static String cn = null;
    private static boolean interactive = false;
    private static boolean verbose = false;
    private static boolean noPswd = false;
    private static String dir = null;
    private static boolean force = false;
    private static String prefix = null;
    private static boolean debug = false;

    public static void main(String[] args) {
        GridCertRequest.parseCmdLine(args);
        File certDir = new File(dir);
        if (!certDir.exists() && !certDir.mkdirs()) {
            GridCertRequest.exit("Unable to create " + certDir + " directory.", 1);
        }
        if (!certDir.isDirectory()) {
            GridCertRequest.exit("The directory " + certDir + " specified is not a directory.", 2);
        }
        if (!certDir.canWrite()) {
            GridCertRequest.exit("Can't write to " + certDir, 3);
        }
        File certFile = new File(certDir, prefix + "cert.pem");
        File keyFile = new File(certDir, prefix + "key.pem");
        File certRequestFile = new File(certDir, prefix + "cert_request.pem");
        if (!force) {
            boolean fileExists = false;
            if (keyFile.exists()) {
                System.err.println(keyFile + " exists");
                fileExists = true;
            }
            if (certFile.exists()) {
                System.err.println(certFile + " exists");
                fileExists = true;
            }
            if (certRequestFile.exists()) {
                System.err.println(certRequestFile + " exists");
                fileExists = true;
            }
            if (fileExists) {
                GridCertRequest.exit("If you wish to overwrite, run the script again with -force.", 4);
            }
        }
        String password = null;
        if (!noPswd) {
            int attempts = 0;
            boolean passOK = false;
            System.out.println(MESSAGE);
            while (attempts < 3) {
                password = Util.getPrivateInput("Enter PEM pass phrase: ");
                if (password.length() < 4) {
                    System.out.println("Phrase is too short, needs to be at least 4 chars");
                    ++attempts;
                    continue;
                }
                String password2 = Util.getPrivateInput("Verifying password - Enter PEM pass phrase: ");
                if (password.compareTo(password2) == 0) {
                    passOK = true;
                    break;
                }
                System.out.println("Verify failure");
                ++attempts;
            }
            if (!passOK) {
                GridCertRequest.exit("Too many attempts", 5);
            }
        }
        try {
            GridCertRequest.genCertificateRequest(cn, caEmail, password, keyFile, certFile, certRequestFile);
        }
        catch (Exception e) {
            System.err.println("Error generating cert request: " + e.getMessage());
            if (debug) {
                e.printStackTrace();
            }
            System.exit(6);
        }
    }

    private static void exit(String msg, int errorCode) {
        System.err.println("Error: " + msg);
        System.exit(errorCode);
    }

    private static void exit(String msg) {
        GridCertRequest.exit(msg, 1);
    }

    protected static void parseCmdLine(String[] args) {
        CoGProperties props;
        String hostName = null;
        String service = null;
        String orgBaseDN = null;
        String name = System.getProperty("user.name");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-version")) {
                System.err.println(Version.getVersion());
                System.exit(1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("-?")) {
                GridCertRequest.exit(USAGE, 0);
                continue;
            }
            if (args[i].equalsIgnoreCase("-cn") || args[i].equalsIgnoreCase("-commonname")) {
                if (++i == args.length) {
                    GridCertRequest.exit("-cn requires an argument");
                    continue;
                }
                name = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-service")) {
                if (++i == args.length) {
                    GridCertRequest.exit("-service requires an argument");
                    continue;
                }
                service = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                if (++i == args.length) {
                    GridCertRequest.exit("-host requires an argument");
                    continue;
                }
                hostName = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dir")) {
                if (++i == args.length) {
                    GridCertRequest.exit("-dir requires an argument");
                    continue;
                }
                dir = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-prefix")) {
                if (++i == args.length) {
                    GridCertRequest.exit("-prefix requires an argument");
                    continue;
                }
                prefix = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-nopw") || args[i].equalsIgnoreCase("-nodes") || args[i].equalsIgnoreCase("-nopassphrase")) {
                noPswd = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-int") || args[i].equalsIgnoreCase("-interactive")) {
                interactive = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-force")) {
                force = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-caEmail")) {
                if (++i == args.length) {
                    GridCertRequest.exit("-caEmail requires an argument");
                    continue;
                }
                caEmail = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-orgBaseDN")) {
                if (++i == args.length) {
                    GridCertRequest.exit("-orgBaseDN requires an argument");
                    continue;
                }
                orgBaseDN = args[i];
                continue;
            }
            GridCertRequest.exit("argument #" + (i + 1) + "(" + args[i] + ") : unknown");
        }
        if (orgBaseDN == null && (orgBaseDN = (props = CoGProperties.getDefault()).getProperty("orgBaseDN")) == null) {
            orgBaseDN = interactive ? GridCertRequest.getOrgName() : "O=Grid";
        }
        if (service != null) {
            if (hostName == null) {
                GridCertRequest.exit("-host required");
            } else {
                cn = orgBaseDN + ", CN=" + service + "/" + hostName;
                noPswd = true;
                if (prefix == null) {
                    prefix = service;
                }
                if (dir == null && ConfigUtil.getOS() == 1) {
                    dir = "/etc/grid-security/" + service;
                }
            }
        } else if (hostName != null) {
            cn = orgBaseDN + ", CN=host/" + hostName;
            noPswd = true;
            if (prefix == null) {
                prefix = "host";
            }
            if (dir == null && ConfigUtil.getOS() == 1) {
                dir = "/etc/grid-security";
            }
        } else {
            cn = orgBaseDN + ", CN=" + name;
            if (prefix == null) {
                prefix = "user";
            }
        }
        if (dir == null) {
            dir = System.getProperty("user.home") + File.separator + ".globus";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void genCertificateRequest(String dname, String emailAddressOfCA, String password, File keyFile, File certFile, File certReqFile) throws Exception {
        String sigAlgName = "MD5WithRSA";
        String keyAlgName = "RSA";
        CertUtil.init();
        X509Name name = new X509Name(dname);
        String certSubject = X509NameHelper.toString(name);
        System.out.println("Generating a 1024 bit RSA private key");
        KeyPairGenerator keygen = KeyPairGenerator.getInstance(keyAlgName);
        keygen.initialize(1024);
        KeyPair keyPair = keygen.genKeyPair();
        PrivateKey privKey = keyPair.getPrivate();
        PublicKey pubKey = keyPair.getPublic();
        DERSet derSet = new DERSet();
        PKCS10CertificationRequest request = new PKCS10CertificationRequest(sigAlgName, name, pubKey, (ASN1Set)derSet, privKey);
        byte[] data = request.getEncoded();
        byte[] encodedData = Base64.encode(data);
        PrintStream ps = null;
        try {
            ps = new PrintStream(new FileOutputStream(certReqFile));
            boolean caEmail = false;
            if (emailAddressOfCA != null && emailAddressOfCA.length() > 0) {
                caEmail = true;
                ps.print("\n\nPlease mail the following certificate request to " + emailAddressOfCA);
            } else {
                ps.print("\n\nPlease send the following certificate request to the Certificate Authority (CA). Refer to CA instructions for details on to send the request.");
            }
            ps.print("\n\n==================================================================\n\nCertificate Subject:\n\n" + certSubject + "\n\nThe above string is known as your user certificate subject, and it \nuniquely identifies this user.\n\nTo install this user certificate, please save this e-mail message\ninto the following file.\n\n\n" + certReqFile.getAbsolutePath() + "\n\n\n      You need not edit this message in any way. Simply \n      save this e-mail message to the file.\n\n\nIf you have any questions about the certificate contact\nthe Certificate Authority");
            if (caEmail) {
                ps.print("at " + emailAddressOfCA);
            }
            ps.print("\n\n");
            PEMUtils.writeBase64(ps, "-----BEGIN CERTIFICATE REQUEST-----", encodedData, "-----END CERTIFICATE REQUEST-----");
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        BouncyCastleOpenSSLKey key = new BouncyCastleOpenSSLKey(privKey);
        if (password != null) {
            key.encrypt(password);
        }
        key.writeTo(keyFile.getAbsolutePath());
        certFile.createNewFile();
        System.out.println("A private key and a certificate request has been generated with the subject:");
        System.out.println();
        System.out.println(certSubject);
        System.out.println();
        System.out.println("The private key is stored in " + keyFile.getAbsolutePath());
        System.out.println("The request is stored in " + certReqFile.getAbsolutePath());
    }

    private static String getOrgName() {
        System.out.println("-----");
        System.out.println("You are about to be asked to enter information that will be incorporated");
        System.out.println("into your certificate request.");
        System.out.println("What you are about to enter is what is called a Distinguished Name or a DN.");
        System.out.println("Enter organization DN by entering individual component names and their values.");
        System.out.println("The component name can be one of: " + X509Name.DefaultLookUp.keySet());
        System.out.println("-----");
        StringBuffer orgName = new StringBuffer();
        String component = null;
        while ((component = GridCertRequest.getComponent()) != null) {
            if (orgName.length() != 0) {
                orgName.append(", ");
            }
            orgName.append(component);
        }
        if (orgName.length() == 0) {
            GridCertRequest.exit("Invalid organization DN");
        }
        return orgName.toString();
    }

    private static String getComponent() {
        String component = null;
        while (true) {
            if ((component = Util.getInput("Enter name component: ")) == null || component.trim().length() == 0) {
                return null;
            }
            if (X509Name.DefaultLookUp.get((component = component.trim()).toLowerCase()) != null) break;
            System.out.println("Invalid component name");
        }
        component = component.toUpperCase();
        String value = Util.getInput("Enter '" + component + "' value: ");
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return component + "=" + value.trim();
    }
}

