/*
 * Decompiled with CFR 0.152.
 */
package org.globusonline.transfer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import org.globusonline.transfer.APIError;
import org.globusonline.transfer.BCTransferAPIClient;
import org.globusonline.transfer.TransferDocument;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONTransferAPIClient
extends BCTransferAPIClient {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: java org.globusonline.transfer.JSONTransferAPIClient username [path [cafile certfile keyfile [baseurl]]]");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = "/tasksummary";
        if (stringArray.length > 1 && stringArray[1].length() > 0) {
            string2 = stringArray[1];
        }
        String string3 = null;
        if (stringArray.length > 2 && stringArray[2].length() > 0) {
            string3 = stringArray[2];
        }
        String string4 = null;
        if (stringArray.length > 3 && stringArray[3].length() > 0) {
            string4 = stringArray[3];
        }
        String string5 = null;
        if (stringArray.length > 4 && stringArray[4].length() > 0) {
            string5 = stringArray[4];
        }
        String string6 = null;
        if (stringArray.length > 5 && stringArray[5].length() > 0) {
            string6 = stringArray[5];
        }
        try {
            JSONTransferAPIClient jSONTransferAPIClient = new JSONTransferAPIClient(string, string3, string4, string5, string6);
            Result result = jSONTransferAPIClient.getResult(string2);
            System.out.println(result.statusCode + " " + result.statusMessage);
            System.out.println(result.document.toString(2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JSONTransferAPIClient(String string) throws KeyManagementException, NoSuchAlgorithmException {
        this(string, null, (String)null, (String)null, null);
    }

    public JSONTransferAPIClient(String string, String string2) throws KeyManagementException, NoSuchAlgorithmException {
        this(string, null, (String)null, (String)null, string2);
    }

    public JSONTransferAPIClient(String string, String string2, String string3) throws KeyManagementException, NoSuchAlgorithmException {
        this(string, string2, (String)null, (String)null, string3);
    }

    public JSONTransferAPIClient(String string, String string2, String string3, String string4) throws KeyManagementException, NoSuchAlgorithmException {
        this(string, string2, string3, string4, null);
    }

    public JSONTransferAPIClient(String string, String string2, String string3, String string4, String string5) throws KeyManagementException, NoSuchAlgorithmException {
        super(string, "application/json", string2, string3, string4, string5);
    }

    public JSONTransferAPIClient(String string, String string2, KeyManager[] keyManagerArray, String string3) throws KeyManagementException, NoSuchAlgorithmException {
        super(string, "application/json", string2, keyManagerArray, string3);
    }

    @Override
    protected APIError constructAPIError(int n, String string, String string2, InputStream inputStream) {
        APIError aPIError = new APIError(n, string, string2);
        try {
            JSONObject jSONObject = new JSONObject(JSONTransferAPIClient.readString(inputStream));
            aPIError.requestId = jSONObject.getString("request_id");
            aPIError.resource = jSONObject.getString("resource");
            aPIError.code = jSONObject.getString("code");
            aPIError.message = jSONObject.getString("message");
        }
        catch (Exception exception) {
            aPIError.message = exception.toString();
        }
        return aPIError;
    }

    public Result getResult(String string) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        return this.getResult(string, null);
    }

    public Result getResult(String string, Map<String, String> map) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        return this.requestResult("GET", string, null, map);
    }

    public Result postResult(String string, JSONObject jSONObject) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        return this.postResult(string, jSONObject, null);
    }

    public Result postResult(String string, JSONObject jSONObject, Map<String, String> map) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        return this.requestResult("POST", string, jSONObject, map);
    }

    public Result putResult(String string, JSONObject jSONObject) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        return this.putResult(string, jSONObject, null);
    }

    public Result putResult(String string, JSONObject jSONObject, Map<String, String> map) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        return this.requestResult("PUT", string, jSONObject, map);
    }

    public Result deleteResult(String string) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        return this.deleteResult(string, null);
    }

    public Result deleteResult(String string, Map<String, String> map) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        return this.requestResult("DELETE", string, null, map);
    }

    public Result requestResult(String string, String string2, JSONObject jSONObject, Map<String, String> map) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        String string3 = null;
        if (jSONObject != null) {
            string3 = jSONObject.toString();
        }
        HttpsURLConnection httpsURLConnection = this.request(string, string2, string3, map);
        Result result = new Result();
        result.statusCode = httpsURLConnection.getResponseCode();
        result.statusMessage = httpsURLConnection.getResponseMessage();
        result.document = new JSONObject(JSONTransferAPIClient.readString(httpsURLConnection.getInputStream()));
        httpsURLConnection.disconnect();
        return result;
    }

    public Result endpointDeactivate(String string) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        String string2 = JSONTransferAPIClient.endpointPath(string) + "/deactivate";
        return this.postResult(string2, null);
    }

    public Result endpointAutoactivate(String string, Map<String, String> map) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        String string2 = JSONTransferAPIClient.endpointPath(string) + "/autoactivate";
        return this.postResult(string2, null, map);
    }

    public Result endpointLs(String string, String string2) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        String string3 = JSONTransferAPIClient.endpointPath(string) + "/ls";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string2 != null) {
            hashMap.put("path", string2);
        }
        return this.getResult(string3, hashMap);
    }

    public String getSubmissionId() throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        Result result = this.getResult("/submission_id");
        return result.document.getString("value");
    }

    public Result transfer(JSONObject jSONObject) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        return this.postResult("/transfer", jSONObject);
    }

    public Result transfer(TransferDocument transferDocument) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        return this.transfer(transferDocument.getJSONObject());
    }

    public Result task(String string, Map<String, String> map) throws IOException, MalformedURLException, GeneralSecurityException, JSONException, APIError {
        String string2 = "/task/" + string;
        return this.getResult(string2, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream inputStream) throws IOException {
        Reader reader = null;
        try {
            int n;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[8192];
            while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static class Result {
        public JSONObject document = null;
        public int statusCode = -1;
        public String statusMessage = null;
    }
}

