/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.IetfAttrSyntax;
import org.bouncycastle.asn1.x509.Target;
import org.bouncycastle.asn1.x509.TargetInformation;
import org.bouncycastle.asn1.x509.Targets;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.VOMSGenericAttribute;
import org.italiangrid.voms.ac.impl.VOMSAttributesImpl;
import org.italiangrid.voms.ac.impl.VOMSGenericAttributeImpl;
import org.italiangrid.voms.asn1.VOMSConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VOMSACUtils
implements VOMSConstants {
    public static final String POLICY_AUTHORITY_SEP = "://";

    public static byte[] getVOMSExtensionFromCertificate(X509Certificate cert) {
        return cert.getExtensionValue(VOMSConstants.VOMS_EXTENSION_OID.getId());
    }

    public static List<AttributeCertificate> getACsFromVOMSExtension(byte[] vomsExtension) throws IOException {
        ArrayList<AttributeCertificate> acs = null;
        if (vomsExtension == null) {
            return Collections.emptyList();
        }
        acs = new ArrayList<AttributeCertificate>();
        ASN1InputStream asn1Stream = new ASN1InputStream(new ByteArrayInputStream(vomsExtension));
        byte[] payload = ((DEROctetString)((Object)asn1Stream.readObject())).getOctets();
        asn1Stream.close();
        asn1Stream = new ASN1InputStream(new ByteArrayInputStream(payload));
        ASN1Sequence baseSequence = (ASN1Sequence)((Object)asn1Stream.readObject());
        asn1Stream.close();
        Enumeration setSequence = baseSequence.getObjects();
        while (setSequence.hasMoreElements()) {
            ASN1Sequence acSequence = (ASN1Sequence)setSequence.nextElement();
            Enumeration theACs = acSequence.getObjects();
            while (theACs.hasMoreElements()) {
                AttributeCertificate parsedAC = new AttributeCertificate((ASN1Sequence)theACs.nextElement());
                acs.add(parsedAC);
            }
        }
        return acs;
    }

    public static List<AttributeCertificate> getACsFromCertificate(X509Certificate cert) throws IOException {
        return VOMSACUtils.getACsFromVOMSExtension(VOMSACUtils.getVOMSExtensionFromCertificate(cert));
    }

    private static List<String> deserializeFQANs(IetfAttrSyntax attr) {
        ASN1OctetString[] values;
        if (attr.getValueType() != 1) {
            VOMSACUtils.raiseACNonConformantError("unsupported attribute values encoding.");
        }
        ArrayList<String> fqans = new ArrayList<String>();
        for (ASN1OctetString s : values = (ASN1OctetString[])attr.getValues()) {
            fqans.add(new String(s.getOctets()));
        }
        return fqans;
    }

    private static List<String> deserializeACTargets(X509AttributeCertificateHolder ac) {
        ArrayList<String> targets = new ArrayList<String>();
        X509Extension targetExtension = ac.getExtension(X509Extension.targetInformation);
        if (targetExtension == null) {
            return targets;
        }
        TargetInformation ti = TargetInformation.getInstance((ASN1Sequence)targetExtension.getParsedValue());
        Targets asn1TargetContainer = ti.getTargetsObjects()[0];
        ASN1Sequence targetSequence = (ASN1Sequence)((Object)asn1TargetContainer.getDERObject());
        Target[] asn1Targets = new Target[targetSequence.size()];
        int count = 0;
        Enumeration e = targetSequence.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence seq = (ASN1Sequence)e.nextElement();
            ASN1TaggedObject val = (ASN1TaggedObject)((Object)seq.getObjectAt(0));
            asn1Targets[count++] = Target.getInstance(val);
        }
        for (Target t : asn1Targets) {
            GeneralName targetURI = t.getTargetName();
            if (targetURI.getTagNo() != 6) {
                VOMSACUtils.raiseACNonConformantError("wrong AC target extension encoding. Only URI targets are supported.");
            }
            String targetString = ((DERIA5String)((Object)targetURI.getName())).getString();
            targets.add(targetString);
        }
        return targets;
    }

    private static void raiseACNonConformantError(String errorString) {
        throw new VOMSError("Non conformant VOMS Attribute certificate: " + errorString);
    }

    private static String policyAuthoritySanityChecks(IetfAttrSyntax attr) {
        String policyAuthority = ((DERIA5String)((Object)attr.getPolicyAuthority().getNames()[0].getName())).getString();
        int index = policyAuthority.indexOf(POLICY_AUTHORITY_SEP);
        if (index < 0 || index == policyAuthority.length() - 1) {
            VOMSACUtils.raiseACNonConformantError("unsupported policy authority encoding '" + policyAuthority + "'");
        }
        return policyAuthority;
    }

    public static List<VOMSAttribute> deserializeVOMSAttributes(List<AttributeCertificate> acs) {
        if (acs == null || acs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<VOMSAttribute> attributes = new ArrayList<VOMSAttribute>();
        for (AttributeCertificate a : acs) {
            attributes.add(VOMSACUtils.deserializeVOMSAttributes(a));
        }
        return attributes;
    }

    public static VOMSAttribute deserializeVOMSAttributes(AttributeCertificate ac) {
        Attribute[] asn1Attrs;
        VOMSAttributesImpl attrs = new VOMSAttributesImpl();
        X509AttributeCertificateHolder acHolder = new X509AttributeCertificateHolder(ac);
        for (Attribute a : asn1Attrs = acHolder.getAttributes(VOMS_FQANS_OID)) {
            DERObject theVOMSDerObject = a.getAttributeValues()[0].getDERObject();
            IetfAttrSyntax attrSyntax = new IetfAttrSyntax(ASN1Sequence.getInstance(theVOMSDerObject));
            String policyAuthority = VOMSACUtils.policyAuthoritySanityChecks(attrSyntax);
            attrs.setVO(policyAuthority.substring(0, policyAuthority.indexOf(POLICY_AUTHORITY_SEP)));
            attrs.setHost(policyAuthority.substring(policyAuthority.indexOf(POLICY_AUTHORITY_SEP) + 3, policyAuthority.lastIndexOf(":")));
            attrs.setPort(Integer.parseInt(policyAuthority.substring(policyAuthority.lastIndexOf(":") + 1)));
            attrs.setFQANs(VOMSACUtils.deserializeFQANs(attrSyntax));
            attrs.setNotBefore(acHolder.getNotBefore());
            attrs.setNotAfter(acHolder.getNotAfter());
            attrs.setSignature(acHolder.getSignature());
            attrs.setGenericAttributes(VOMSACUtils.deserializeGAs(acHolder));
            attrs.setAACertificates(VOMSACUtils.deserializeACCerts(acHolder));
            attrs.setTargets(VOMSACUtils.deserializeACTargets(acHolder));
            attrs.setVOMSAC(acHolder);
            try {
                attrs.setIssuer(new X500Principal(acHolder.getIssuer().getNames()[0].getEncoded()));
                attrs.setHolder(new X500Principal(acHolder.getHolder().getIssuer()[0].getEncoded()));
                attrs.setHolderSerialNumber(acHolder.getHolder().getSerialNumber());
            }
            catch (IOException e) {
                throw new VOMSError("Error parsing attribute certificate issuer  or holder name: " + e.getMessage(), e);
            }
        }
        return attrs;
    }

    private static List<VOMSGenericAttribute> deserializeGAs(X509AttributeCertificateHolder ac) {
        ASN1Sequence tagListSeq;
        ArrayList<VOMSGenericAttribute> gas = new ArrayList<VOMSGenericAttribute>();
        X509Extension gasExtension = ac.getExtension(VOMS_GENERIC_ATTRS_OID);
        if (gasExtension == null) {
            return gas;
        }
        ASN1Sequence tagContainerSeq = (ASN1Sequence)gasExtension.getParsedValue();
        if (tagContainerSeq.size() != 1) {
            VOMSACUtils.raiseACNonConformantError("unsupported generic attributes container format.");
        }
        if ((tagListSeq = (ASN1Sequence)((Object)tagContainerSeq.getObjectAt(0))).size() > 1) {
            VOMSACUtils.raiseACNonConformantError("unsupported taglist format.");
        }
        if (tagListSeq.size() == 0) {
            return gas;
        }
        tagListSeq = (ASN1Sequence)((Object)tagListSeq.getObjectAt(0));
        ASN1Sequence tags = (ASN1Sequence)((Object)tagListSeq.getObjectAt(1));
        Enumeration e = tags.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence theActualTag = (ASN1Sequence)e.nextElement();
            if (theActualTag.size() != 3) {
                VOMSACUtils.raiseACNonConformantError("unsupported tag format.");
            }
            VOMSGenericAttributeImpl attribute = new VOMSGenericAttributeImpl();
            attribute.setName(new String(DEROctetString.getInstance(theActualTag.getObjectAt(0)).getOctets()));
            attribute.setValue(new String(DEROctetString.getInstance(theActualTag.getObjectAt(1)).getOctets()));
            attribute.setContext(new String(DEROctetString.getInstance(theActualTag.getObjectAt(2)).getOctets()));
            gas.add(attribute);
        }
        return gas;
    }

    private static X509Certificate[] deserializeACCerts(X509AttributeCertificateHolder ac) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        X509Extension e = ac.getExtension(VOMS_CERTS_OID);
        if (e == null) {
            return null;
        }
        ASN1Sequence certSeq = (ASN1Sequence)e.getParsedValue();
        if (certSeq.size() != 1) {
            VOMSACUtils.raiseACNonConformantError("unsupported accerts format.");
        }
        certSeq = (ASN1Sequence)((Object)certSeq.getObjectAt(0));
        Enumeration encodedCerts = certSeq.getObjects();
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509", BouncyCastleProvider.PROVIDER_NAME);
        }
        catch (Exception ex) {
            throw new VOMSError("Certificate factory creation error: " + ex.getMessage(), ex);
        }
        while (encodedCerts.hasMoreElements()) {
            DERSequence s = (DERSequence)encodedCerts.nextElement();
            X509CertificateObject certObj = null;
            byte[] certData = null;
            X509Certificate theCert = null;
            try {
                certObj = new X509CertificateObject(X509CertificateStructure.getInstance(ASN1Sequence.getInstance(s)));
                certData = certObj.getEncoded();
                theCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certData));
            }
            catch (CertificateParsingException ex) {
                throw new VOMSError("Certificate parsing error: " + ex.getMessage(), ex);
            }
            catch (CertificateEncodingException ex) {
                throw new VOMSError("Certificate encoding error: " + ex.getMessage(), ex);
            }
            catch (CertificateException ex) {
                throw new VOMSError("Error generating certificate from parsed data: " + ex.getMessage(), ex);
            }
            certs.add(theCert);
        }
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    private VOMSACUtils() {
    }
}

