/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.response;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ErrorDetail {
    private List<ErrorDetailEntity> errors;
    private Integer success;
    private Integer failed;

    public ErrorDetail(List<ErrorDetailEntity> errors) {
        this.errors = errors;
    }

    public ErrorDetail(Integer success, Integer failed) {
        this.success = success;
        this.failed = failed;
    }

    public ErrorDetail(Integer success, Integer failed, List<ErrorDetailEntity> errors) {
        this.success = success;
        this.failed = failed;
        this.errors = errors;
    }

    public ErrorDetail(ErrorDetailEntity error) {
        this.errors = Collections.singletonList(error);
    }

    public List<ErrorDetailEntity> getErrors() {
        return this.errors;
    }

    public Integer getSuccess() {
        return this.success;
    }

    public void setSuccess(Integer success) {
        this.success = success;
    }

    public Integer getFailed() {
        return this.failed;
    }

    public void setFailed(Integer failed) {
        this.failed = failed;
    }

    public String toString() {
        return "ErrorDetail [success=" + this.success + ", failed=" + this.failed + ", errors=" + this.errors + "]";
    }

    public static class DataPoint {
        private String metric;
        private long timestamp;
        private Object value;
        private Map<String, String> tags = new HashMap<String, String>();

        public String getMetric() {
            return this.metric;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }
    }

    public static class ErrorDetailEntity {
        private DataPoint datapoint;
        private String error;

        public DataPoint getDatapoint() {
            return this.datapoint;
        }

        public void setDatapoint(DataPoint datapoint) {
            this.datapoint = datapoint;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String toString() {
            return "ErrorDetailEntity [datapoint=" + this.datapoint + ", error=" + this.error + "]";
        }
    }
}

