/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.mru;

import com.sshtools.common.mru.MRUList;
import java.io.File;
import javax.swing.AbstractListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MRUListModel
extends AbstractListModel {
    private static Log log = LogFactory.getLog(MRUListModel.class);
    private MRUList mru;

    public MRUListModel() {
        this.setMRUList(new MRUList());
    }

    public void add(File f) {
        int i;
        this.mru.insertElementAt(f, 0);
        for (i = this.mru.size() - 1; i >= 1; --i) {
            if (!((File)this.mru.elementAt(i)).equals(f)) continue;
            this.mru.removeElementAt(i);
        }
        if (this.mru.size() > 15) {
            for (i = this.mru.size() - 1; i >= 15; --i) {
                this.mru.removeElementAt(i);
            }
        }
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    @Override
    public Object getElementAt(int i) {
        return this.mru.get(i);
    }

    @Override
    public int getSize() {
        return this.mru == null ? 0 : this.mru.size();
    }

    public void setMRUList(MRUList mru) {
        this.mru = mru;
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public MRUList getMRUList() {
        return this.mru;
    }
}

