/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.mru;

import com.sshtools.common.mru.MRUListModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MRUMenu
extends JMenu
implements ListDataListener,
ActionListener {
    private MRUListModel model;

    protected MRUMenu(Action action, MRUListModel model) {
        super(action);
        this.init(model);
    }

    protected MRUMenu(String text, MRUListModel model) {
        super(text);
        this.init(model);
    }

    private void init(MRUListModel model) {
        this.model = model;
        this.rebuildMenu();
        model.addListDataListener(this);
    }

    public void cleanUp() {
        this.model.removeListDataListener(this);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.rebuildMenu();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.rebuildMenu();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.rebuildMenu();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.fireActionPerformed(evt);
    }

    private void rebuildMenu() {
        int i;
        Component[] c = this.getMenuComponents();
        for (i = 0; c != null && i < c.length; ++i) {
            ((JMenuItem)c[i]).removeActionListener(this);
            this.remove(c[i]);
        }
        for (i = 0; i < this.model.getSize(); ++i) {
            File f = (File)this.model.getElementAt(i);
            JMenuItem m = new JMenuItem(f.getName());
            m.setActionCommand(f.getAbsolutePath());
            m.setToolTipText(f.getAbsolutePath());
            m.addActionListener(this);
            this.add(m);
        }
        this.setEnabled(this.model.getSize() > 0);
        this.validate();
    }
}

