/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.vomanagementtool.common;

import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.vomanagementtool.ExtraPanel;
import com.sshtools.j2ssh.authentication.UserGridCredential;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class VOHelper {
    private static TreeMap allVOs = null;
    private static String vomsConfigURL = PreferencesStore.get("sshterm.voms.config.url", "https://www.lrz.de/services/compute/grid_res/misc/voms/config.tar.gz");
    private static String vomslocation = PreferencesStore.get("sshterm.voms.location", UserGridCredential.DEFAULT_VOMS_LOCATION);
    private static String vomses = vomslocation + File.separator + "vomses";
    private static String vomsdir = vomslocation + File.separator + "voms";
    private static String favouritesFile = vomslocation + File.separator + "vomses" + File.separator + "Favourites";
    private static String[] listeInfra;
    public static final String FAVOURITES = "Favourites";
    public static final String EGI = "egi";
    public static final String OTHERS = "ige";

    public static void refreshVOMSConfig() {
        vomses = vomslocation + File.separator + "vomses";
        vomsdir = vomslocation + File.separator + "voms";
        favouritesFile = vomses + File.separator + FAVOURITES;
    }

    public static void setupVOMSProperties() {
        System.setProperty("VOMSES_LOCATION", vomses);
        System.setProperty("VOMSDIR", vomsdir);
        System.setProperty("CADIR", System.getProperty("user.home") + File.separator + ".globus" + File.separator + "certificates");
    }

    public static boolean checkVOExists(String voName, String server) {
        boolean isExist = false;
        String voDir = vomsdir + File.separator + voName;
        String voFilelsc = voDir + File.separator + server + ".lsc";
        if (new File(voDir).isDirectory() && new File(voFilelsc).isFile()) {
            isExist = true;
            JOptionPane.showMessageDialog(null, "This VO '" + voName + "' with server '+ server +' already exists.", "Error: Add new VO", 0);
        }
        return isExist;
    }

    public static boolean retrieveSetup() {
        boolean isSuccessful = false;
        allVOs = new TreeMap();
        File folder = new File(vomses);
        if (folder.isDirectory()) {
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles != null) {
                listeInfra = new String[listOfFiles.length];
            }
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile()) continue;
                String group = listOfFiles[i].getName();
                TreeMap vos = VOHelper.readVomsesFile(listOfFiles[i]);
                allVOs.put(group, vos);
                VOHelper.listeInfra[i] = group;
                isSuccessful = true;
            }
        }
        return isSuccessful;
    }

    public static void checkUpdateVOMSConfigFiles() throws IOException {
        GZIPInputStream in;
        boolean success;
        VOHelper.refreshVOMSConfig();
        if (!new File(vomslocation).exists() && !(success = new File(vomslocation).mkdir())) {
            throw new IOException("Couldn't create directory for VOMS support: " + vomslocation);
        }
        if (!new File(vomslocation).isDirectory()) {
            throw new IOException("Location: " + vomslocation + " is not a directory");
        }
        URL vomsURL = new URL(vomsConfigURL);
        try {
            in = new GZIPInputStream(vomsURL.openStream());
        }
        catch (FileNotFoundException fnf) {
            throw new IOException("URL: " + vomslocation + " does not exists.");
        }
        catch (IOException ioe) {
            throw new IOException("Failed to download VOMS config '" + vomsConfigURL + "'.\n" + ioe.getMessage());
        }
        try {
            VOHelper.untar(in, vomslocation);
        }
        catch (IOException ioe) {
            throw new IOException("Untarring VOMS config into '" + vomslocation + "'.\n" + ioe.getMessage());
        }
        if (!new File(favouritesFile).exists() && !(success = new File(favouritesFile).createNewFile())) {
            throw new IOException("Couldn't create 'Favourites' directory to allow you to store your VOs: " + favouritesFile);
        }
        try {
            VOHelper.Chmod(true, "755", vomslocation);
        }
        catch (IOException ioe) {
            throw new IOException("Cannot change directory permission of " + vomslocation + ".");
        }
    }

    public static boolean addNewVO(TreeMap info) throws IOException {
        boolean isSuccessful;
        block8: {
            String lscfile;
            isSuccessful = false;
            String voname = (String)info.get("localvoname");
            String server = (String)info.get("server");
            int port = (Integer)info.get("port");
            String serverdn = (String)info.get("serverdn");
            String serverissuerdn = (String)info.get("serverissuerdn");
            String path = vomsdir + File.separator + voname;
            if (!new File(path).isDirectory() && new File(path).mkdir()) {
                try {
                    VOHelper.Chmod(true, "go-w", path);
                }
                catch (IOException e) {
                    throw new IOException("Cannot change directory permission of " + vomslocation + ".");
                }
            }
            if (!new File(lscfile = path + File.separator + server + ".lsc").isFile()) {
                String content = serverdn + "\n" + serverissuerdn;
                try {
                    VOHelper.writeToFile(lscfile, content);
                    String lscString = "\"" + voname + "\"" + " \"" + server + "\"" + " \"" + port + "\"" + " \"" + serverdn + "\"" + " \"" + voname + "\"";
                    try {
                        VOHelper.appendLineToFavourites(lscString);
                        isSuccessful = true;
                        break block8;
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to append line\n" + lscString + "\nto " + voname + ".lsc file.");
                    }
                }
                catch (IOException e) {
                    throw new IOException("Failed to create " + voname + ".lsc file.");
                }
            }
            throw new IOException("VO '" + voname + "' with server '" + server + "' already exists.");
        }
        return isSuccessful;
    }

    public static boolean addVOToFavourites(String voName, String fromGroup) {
        boolean isAdded = false;
        TreeMap allFavVOs = VOHelper.getVOGroup(FAVOURITES);
        if (allFavVOs.containsKey(voName)) {
            JOptionPane.showMessageDialog(null, "VO '" + voName + "' is already in " + FAVOURITES + ".", "Error: Add VO to Favourites", 0);
        } else {
            TreeMap groupVOs = VOHelper.getVOGroup(fromGroup);
            if (groupVOs.containsKey(voName)) {
                List voDetails = (List)groupVOs.get(voName);
                allFavVOs.put(voName, voDetails);
                String newContent = VOHelper.createStringFromTreeMap(allFavVOs);
                try {
                    VOHelper.writeToFile(favouritesFile, newContent);
                    isAdded = true;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "Cannot add VO '" + voName + "' to " + FAVOURITES + ". Write to file '" + favouritesFile + "' failed", "Error: Add VO to Favourites", 0);
                }
            }
        }
        return isAdded;
    }

    public static boolean removeVOFromFavourites(String voName) {
        boolean isRemoved = false;
        TreeMap allFavVOs = VOHelper.getVOGroup(FAVOURITES);
        for (Map.Entry entry : allFavVOs.entrySet()) {
            String vonameinMap = (String)entry.getKey();
            if (!voName.equals(vonameinMap)) continue;
            TreeMap allEGIVOs = VOHelper.getVOGroup(EGI);
            TreeMap allOTHERSVO = VOHelper.getVOGroup(OTHERS);
            if (!allEGIVOs.containsKey(voName) && !allOTHERSVO.containsKey(voName)) {
                try {
                    VOHelper.delete(new File(vomsdir + File.separator + voName));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "Cannot remove dirctory '" + vomsdir + File.separator + voName + "'.", "Error: Remove VO from Favourites", 0);
                }
            }
            allFavVOs.remove(vonameinMap);
            isRemoved = true;
            break;
        }
        if (isRemoved) {
            String newContent = VOHelper.createStringFromTreeMap(allFavVOs);
            try {
                VOHelper.writeToFile(favouritesFile, newContent);
            }
            catch (IOException e) {
                isRemoved = false;
                JOptionPane.showMessageDialog(null, "Failed to remove VO from Favourites. Cannot write to file '" + favouritesFile + "'", "Error: Remove VO", 0);
            }
        }
        return isRemoved;
    }

    public static boolean checkFavouritesChanges() {
        boolean isChanged = false;
        TreeMap favourites = VOHelper.getVOGroup(FAVOURITES);
        TreeMap egis = VOHelper.getVOGroup(EGI);
        TreeMap others = VOHelper.getVOGroup(OTHERS);
        block2: for (Map.Entry favourite : favourites.entrySet()) {
            String favVOName = (String)favourite.getKey();
            List voDetails = (List)favourite.getValue();
            for (int i = 0; i < voDetails.size(); ++i) {
                int reply;
                TreeMap favInfo = (TreeMap)voDetails.get(i);
                boolean isSame = false;
                String group = "";
                if (egis.containsKey(favVOName)) {
                    List egiVODetails = (List)egis.get(favVOName);
                    isSame = VOHelper.compareTreeMapInList(favVOName, favInfo, egiVODetails);
                    group = EGI;
                } else if (others.containsKey(favVOName)) {
                    List othersVODetails = (List)others.get(favVOName);
                    isSame = VOHelper.compareTreeMapInList(favVOName, favInfo, othersVODetails);
                    group = OTHERS;
                }
                if (isSame || group.equals("") || (reply = JOptionPane.showConfirmDialog(null, "VO '" + favVOName + "' setup has been modified in " + group + " setup. Your " + FAVOURITES + " configuration might not work.\n Do you want to update Favourites with the updated configurations?", "Update Favourites configuration", 0, 3, new ResourceIcon(VOHelper.class, "/com/sshtools/common/vomanagementtool/largeVO.png"))) != 0) continue;
                if (group.equals(EGI)) {
                    favourites.put(favVOName, egis.get(favVOName));
                    isChanged = true;
                    continue block2;
                }
                if (!group.equals(OTHERS)) continue block2;
                favourites.put(favVOName, others.get(favVOName));
                isChanged = true;
                continue block2;
            }
        }
        if (isChanged) {
            String newContent = VOHelper.createStringFromTreeMap(favourites);
            try {
                VOHelper.writeToFile(favouritesFile, newContent);
            }
            catch (IOException e) {
                isChanged = false;
                JOptionPane.showMessageDialog(null, "Failed to remove VO from Favourites. Cannot write to file '" + favouritesFile + "'", "Error: Remove VO", 0);
            }
        }
        return isChanged;
    }

    public static boolean compareTreeMapInList(String voName, TreeMap favInfo, List list) {
        boolean isSame = false;
        String favServer = (String)favInfo.get("server");
        String favPort = (String)favInfo.get("port");
        String favDN = (String)favInfo.get("dn");
        for (int j = 0; j < list.size(); ++j) {
            TreeMap info = (TreeMap)list.get(j);
            String egiServer = (String)info.get("server");
            if (!favServer.equals(egiServer)) continue;
            String egiPort = (String)info.get("port");
            String egiDN = (String)info.get("dn");
            if (!egiPort.equals(favPort) || !egiDN.equals(favDN)) continue;
            isSame = true;
            break;
        }
        return isSame;
    }

    public static TreeMap getVOGroup(String group) {
        return (TreeMap)allVOs.get(group);
    }

    private static TreeMap readVomsesFile(File file) {
        TreeMap<String, List> vosInfo = new TreeMap<String, List>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                if (line.trim().equals("")) continue;
                String[] info = line.split("\" \"");
                TreeMap<String, String> temp = null;
                String voname = "";
                for (int i = 0; i < info.length; ++i) {
                    if (i == 0) {
                        temp = new TreeMap<String, String>();
                        voname = info[i].substring(1);
                        continue;
                    }
                    if (i == 4) {
                        temp.put("servervoname", info[i].substring(0, info[i].length() - 1));
                        if (vosInfo.containsKey(voname)) {
                            List multiValue = (List)vosInfo.get(voname);
                            multiValue.add(temp);
                            vosInfo.put(voname, multiValue);
                            continue;
                        }
                        ArrayList<TreeMap<String, String>> singleValue = new ArrayList<TreeMap<String, String>>();
                        singleValue.add(temp);
                        vosInfo.put(voname, singleValue);
                        continue;
                    }
                    if (i == 1) {
                        temp.put("server", info[i]);
                        continue;
                    }
                    if (i == 2) {
                        temp.put("port", info[i]);
                        continue;
                    }
                    if (i != 3) continue;
                    temp.put("dn", info[i]);
                }
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return vosInfo;
    }

    private static void untar(InputStream in, String untarDir) throws IOException {
        TarArchiveInputStream tin = new TarArchiveInputStream(in);
        TarArchiveEntry entry = tin.getNextTarEntry();
        if (new File(untarDir).exists()) {
            File destPath;
            while (entry != null) {
                if (!entry.isSymbolicLink()) {
                    boolean success;
                    String filename = untarDir + File.separatorChar + entry.getName();
                    destPath = new File(filename);
                    if (!entry.isDirectory()) {
                        FileOutputStream fout = new FileOutputStream(destPath);
                        IOUtils.copy(tin, fout);
                        fout.close();
                    } else if (!destPath.exists() && !(success = destPath.mkdir())) {
                        throw new IOException("Couldn't create directory for VOMS support: " + destPath.getAbsolutePath());
                    }
                }
                entry = tin.getNextTarEntry();
            }
            tin = new TarArchiveInputStream(in);
            entry = tin.getNextTarEntry();
            while (entry != null) {
                if (entry.isSymbolicLink()) {
                    File srcPath = new File(untarDir + File.separatorChar + entry.getLinkName());
                    destPath = new File(untarDir + File.separatorChar + entry.getName());
                    VOHelper.copyFile(srcPath, destPath);
                }
                entry = tin.getNextTarEntry();
            }
        } else {
            throw new IOException("Couldn't find directory: " + untarDir);
        }
        tin.close();
    }

    private static void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private static void Chmod(boolean recursive, String permission, String directoryFile) throws IOException {
        String osName = System.getProperty("os.name");
        String command = "chmod";
        if (recursive) {
            command = command + " -R";
        }
        if (osName.startsWith("Mac OS")) {
            Runtime.getRuntime().exec(command + " " + permission + " " + directoryFile);
        } else if (!osName.startsWith("Windows")) {
            Runtime.getRuntime().exec(command + " " + permission + " " + directoryFile);
        }
    }

    public static boolean createVOMSLOCATIONDialog() {
        boolean isSuccessful = false;
        ExtraPanel.VOMSLocationPanel vomsPanel = new ExtraPanel.VOMSLocationPanel();
        int result = JOptionPane.showConfirmDialog(null, vomsPanel, "VOMS Location", 2, 3, new ResourceIcon(vomsPanel.getClass(), "/com/sshtools/common/vomanagementtool/largeVO.png"));
        if (result == 0 && vomsPanel.getVOMSLocation() != null && !vomsPanel.getVOMSLocation().equals("")) {
            vomslocation = vomsPanel.getVOMSLocation();
            VOHelper.refreshVOMSConfig();
            PreferencesStore.put("sshterm.voms.location", vomslocation);
        }
        return isSuccessful;
    }

    public static boolean createAddVODialog() {
        int result;
        boolean isSuccessful = false;
        ExtraPanel.NewVOPanel newVOPanel = new ExtraPanel.NewVOPanel();
        while ((result = JOptionPane.showConfirmDialog(null, newVOPanel, "New VO", 2, 3, new ResourceIcon(newVOPanel.getClass(), "/com/sshtools/common/vomanagementtool/largeVO.png"))) == 0) {
            String msg = "";
            if (newVOPanel.getServerIssuerDN().equals("")) {
                msg = "Field 'Server Certificate Issuer DN' cannot be empty.";
            }
            if (newVOPanel.getServerDN().equals("")) {
                msg = "Field 'Server DN' cannot be empty.\n" + msg;
            }
            if (newVOPanel.getPort() == 0) {
                msg = "Field 'Port' cannot be empty.\n" + msg;
            }
            if (newVOPanel.getServer().equals("")) {
                msg = "Field 'Server' cannot be empty.\n" + msg;
            }
            if (newVOPanel.getVOName().equals("")) {
                msg = "Field 'VO name' cannot be empty.\n" + msg;
            }
            if (!msg.equals("")) {
                JOptionPane.showMessageDialog(null, msg, "Error: Add new VO", 0);
                continue;
            }
            TreeMap<String, Object> vo = new TreeMap<String, Object>();
            vo.put("localvoname", newVOPanel.getVOName());
            vo.put("servervoname", newVOPanel.getVOName());
            vo.put("server", newVOPanel.getServer());
            vo.put("port", newVOPanel.getPort());
            vo.put("serverdn", newVOPanel.getServerDN());
            vo.put("serverissuerdn", newVOPanel.getServerIssuerDN());
            try {
                isSuccessful = VOHelper.addNewVO(vo);
                break;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error: Add new VO", 0);
            }
        }
        return isSuccessful;
    }

    private static String createStringFromTreeMap(TreeMap treemap) {
        String content = "";
        for (Map.Entry entry : treemap.entrySet()) {
            String vonameinMap = (String)entry.getKey();
            List voDetails = (List)entry.getValue();
            for (int i = 0; i < voDetails.size(); ++i) {
                TreeMap details = (TreeMap)voDetails.get(i);
                String server = (String)details.get("server");
                String port = (String)details.get("port");
                String dn = (String)details.get("dn");
                String servervoname = (String)details.get("servervoname");
                String lscString = "\"" + vonameinMap + "\"" + " \"" + server + "\"" + " \"" + port + "\"" + " \"" + dn + "\"" + " \"" + servervoname + "\"";
                content = content + lscString + "\n";
            }
        }
        return content;
    }

    private static void writeToFile(String filename, String content) throws IOException {
        File newFile = new File(filename);
        if (!newFile.isFile()) {
            newFile.createNewFile();
        }
        PrintWriter out = new PrintWriter(newFile.getAbsolutePath());
        out.println(content);
        out.close();
    }

    private static void appendLineToFavourites(String line) throws IOException {
        BufferedWriter output = new BufferedWriter(new FileWriter(favouritesFile, true));
        output.append(line + "\n");
        ((Writer)output).close();
    }

    private static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    VOHelper.delete(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    public String getVomses() {
        return vomses;
    }

    public String getVomsdir() {
        return vomsdir;
    }

    public void setVomses(String vomses) {
        VOHelper.vomses = vomses;
    }

    public void setVomsdir(String vomsdir) {
        VOHelper.vomsdir = vomsdir;
    }

    public static String[] getListeInfra() {
        return listeInfra;
    }

    public static void setListeInfra(String[] listeInfra) {
        VOHelper.listeInfra = listeInfra;
    }

    public static TreeMap getAllVOs() {
        return allVOs;
    }

    public static void setAllVOs(TreeMap allVOs) {
        VOHelper.allVOs = allVOs;
    }

    public static String getVomslocation() {
        return vomslocation;
    }
}

