/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.lirc.socket.UnixSocket;

public abstract class UNIXSocketChannel
extends Channel {
    private static Log log = LogFactory.getLog(UNIXSocketChannel.class);
    protected UnixSocket socket = null;
    Thread thread;

    public void bindSocket(UnixSocket socket) throws IOException {
        if (this.state.getValue() != 1) {
            throw new IOException("The socket can only be bound to an unitialized channel");
        }
        this.socket = socket;
    }

    @Override
    protected void onChannelData(SshMsgChannelData msg) throws IOException {
        try {
            this.socket.getOutputStream().write(msg.getChannelData());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void onChannelEOF() throws IOException {
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException ex) {
            log.info("Failed to shutdown Socket OutputStream in response to EOF event: " + ex.getMessage());
        }
    }

    @Override
    protected void onChannelClose() throws IOException {
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            log.info("Failed to close socket on channel close event: " + ex.getMessage());
        }
    }

    @Override
    protected void onChannelOpen() throws IOException {
        if (this.socket == null) {
            throw new IOException("The socket must be bound to the channel before opening");
        }
        this.thread = new Thread(new SocketReader());
        this.thread.start();
    }

    @Override
    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
    }

    class SocketReader
    implements Runnable {
        SocketReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] buffer = new byte[UNIXSocketChannel.this.getMaximumPacketSize()];
            ByteArrayWriter baw = new ByteArrayWriter();
            try {
                int read = 0;
                while (read >= 0 && !UNIXSocketChannel.this.isClosed()) {
                    try {
                        read = UNIXSocketChannel.this.socket.getInputStream().read(buffer);
                    }
                    catch (InterruptedIOException ex1) {
                        read = ex1.bytesTransferred;
                    }
                    ChannelState channelState = UNIXSocketChannel.this.state;
                    synchronized (channelState) {
                        if (UNIXSocketChannel.this.isClosed() || UNIXSocketChannel.this.isLocalEOF()) {
                            break;
                        }
                        if (read > 0) {
                            baw.write(buffer, 0, read);
                            UNIXSocketChannel.this.sendChannelData(baw.toByteArray());
                            baw.reset();
                        }
                    }
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                ChannelState ex = UNIXSocketChannel.this.state;
                synchronized (ex) {
                    if (!UNIXSocketChannel.this.isLocalEOF()) {
                        UNIXSocketChannel.this.setLocalEOF();
                    }
                    if (UNIXSocketChannel.this.isOpen()) {
                        UNIXSocketChannel.this.close();
                    }
                }
            }
            catch (Exception ex) {
                log.info("Failed to send channel EOF message: " + ex.getMessage());
            }
            UNIXSocketChannel.this.thread = null;
        }
    }
}

