/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.net;

import com.sshtools.j2ssh.net.HttpHeader;
import com.sshtools.j2ssh.net.HttpRequest;
import com.sshtools.j2ssh.net.HttpResponse;
import com.sshtools.j2ssh.net.TransportProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class HttpProxySocketProvider
extends Socket
implements TransportProvider {
    private String proxyHost;
    private int proxyPort;
    private String remoteHost;
    private int remotePort;
    private HttpResponse responseHeader;
    private String providerDetail;

    private HttpProxySocketProvider(String host, int port, String proxyHost, int proxyPort) throws IOException, UnknownHostException {
        super(proxyHost, proxyPort);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.remoteHost = this.remoteHost;
        this.remotePort = this.remotePort;
    }

    public static HttpProxySocketProvider connectViaProxy(String host, int port, String proxyHost, int proxyPort, String username, String password, String userAgent) throws IOException, UnknownHostException {
        return HttpProxySocketProvider.connectViaProxy(host, port, proxyHost, proxyPort, null, username, password, userAgent);
    }

    public static HttpProxySocketProvider connectViaProxy(String host, int port, String proxyHost, int proxyPort, String protocol, String username, String password, String userAgent) throws IOException, UnknownHostException {
        int status;
        String providerDetail;
        HttpProxySocketProvider socket = new HttpProxySocketProvider(host, port, proxyHost, proxyPort);
        try {
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            HttpRequest request = new HttpRequest();
            if (protocol == null) {
                protocol = "";
            }
            request.setHeaderBegin("CONNECT " + protocol + host + ":" + port + " HTTP/1.0");
            request.setHeaderField("User-Agent", userAgent);
            request.setHeaderField("Pragma", "No-Cache");
            request.setHeaderField("Proxy-Connection", "Keep-Alive");
            out.write(request.toString().getBytes());
            out.flush();
            socket.responseHeader = new HttpResponse(in);
            providerDetail = socket.responseHeader.getHeaderField("server");
            if (socket.responseHeader.getStatus() == 407) {
                String realm = socket.responseHeader.getAuthenticationRealm();
                String method = socket.responseHeader.getAuthenticationMethod();
                if (realm == null) {
                    realm = "";
                }
                if (method.equalsIgnoreCase("basic")) {
                    socket.close();
                    socket = new HttpProxySocketProvider(host, port, proxyHost, proxyPort);
                    in = socket.getInputStream();
                    out = socket.getOutputStream();
                    request.setBasicAuthentication(username, password);
                    out.write(request.toString().getBytes());
                    out.flush();
                    socket.responseHeader = new HttpResponse(in);
                } else {
                    if (method.equalsIgnoreCase("digest")) {
                        throw new IOException("Digest authentication is not supported");
                    }
                    throw new IOException("'" + method + "' is not supported");
                }
            }
            status = socket.responseHeader.getStatus();
        }
        catch (SocketException e) {
            throw new SocketException("Error communicating with proxy server " + proxyHost + ":" + proxyPort + " (" + e.getMessage() + ")");
        }
        if (status < 200 || status > 299) {
            throw new IOException("Proxy tunnel setup failed: " + socket.responseHeader.getStartLine());
        }
        socket.providerDetail = providerDetail;
        return socket;
    }

    @Override
    public String toString() {
        return "HTTPProxySocket [Proxy IP=" + this.getInetAddress() + ",Proxy Port=" + this.getPort() + ",localport=" + this.getLocalPort() + "Remote Host=" + this.remoteHost + "Remote Port=" + String.valueOf(this.remotePort) + "]";
    }

    public HttpHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Override
    public String getProviderDetail() {
        return this.providerDetail;
    }
}

