/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.session;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.session.SessionOutputEcho;

public class SessionOutputReader {
    SessionChannelClient session;
    int pos = 0;
    int mark = 0;
    String output = "";

    public SessionOutputReader(SessionChannelClient session) {
        this.session = session;
        session.addEventListener(new SessionOutputListener());
    }

    public String getOutput() {
        return this.output;
    }

    public int getPosition() {
        return this.pos;
    }

    public void markPosition(int mark) {
        this.mark = mark;
    }

    public void markCurrentPosition() {
        this.mark = this.pos;
    }

    public String getMarkedOutput() {
        return this.output.substring(this.mark, this.pos);
    }

    public synchronized boolean waitForString(String str, SessionOutputEcho echo) throws InterruptedException {
        return this.waitForString(str, 0, echo);
    }

    public synchronized boolean waitForString(String str) throws InterruptedException {
        return this.waitForString(str, 0, null);
    }

    public synchronized boolean waitForString(String str, int timeout) throws InterruptedException {
        return this.waitForString(str, timeout, null);
    }

    public synchronized boolean waitForString(String str, int timeout, SessionOutputEcho echo) throws InterruptedException {
        long time = System.currentTimeMillis();
        while (this.output.indexOf(str, this.pos) == -1 && (System.currentTimeMillis() - time < (long)timeout || timeout == 0)) {
            int tmp = this.output.length();
            this.wait(timeout > 0 ? (long)timeout - (System.currentTimeMillis() - time) : 0L);
            if (this.output.length() <= tmp || echo == null) continue;
            echo.echo(this.output.substring(tmp, this.output.length()));
        }
        if (this.output.indexOf(str, this.pos) > -1) {
            this.pos = this.output.indexOf(str, this.pos) + str.length();
            return true;
        }
        return false;
    }

    public synchronized void echoLineByLineToClose(SessionOutputEcho echo) throws InterruptedException {
        while (this.session.isOpen()) {
            this.waitForString("\n", 1000, echo);
        }
    }

    private synchronized void breakWaiting() {
        this.notifyAll();
    }

    class SessionOutputListener
    implements ChannelEventListener {
        SessionOutputListener() {
        }

        @Override
        public void onChannelOpen(Channel channel) {
        }

        @Override
        public void onChannelClose(Channel channel) {
            SessionOutputReader.this.breakWaiting();
        }

        @Override
        public void onChannelEOF(Channel channel) {
            SessionOutputReader.this.breakWaiting();
        }

        @Override
        public void onDataSent(Channel channel, byte[] data) {
        }

        @Override
        public void onDataReceived(Channel channel, byte[] data) {
            SessionOutputReader.this.output = SessionOutputReader.this.output + new String(data);
            SessionOutputReader.this.breakWaiting();
        }
    }
}

