/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageNotRegisteredException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SshMessageStore {
    private static Log log = LogFactory.getLog(SshMessageStore.class);
    private List messages = new ArrayList();
    private Map register = new HashMap();
    private Map asyncronous = new HashMap();
    private boolean isClosed = false;
    private int[] singleIdFilter = new int[1];
    private int interrupt = 5000;

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized SshMessage getMessage(int[] messageIdFilter) throws MessageStoreEOFException, InterruptedException {
        try {
            return this.getMessage(messageIdFilter, 0);
        }
        catch (MessageNotAvailableException e) {
            throw new MessageStoreEOFException();
        }
    }

    public synchronized SshMessage getMessage(int[] messageIdFilter, int timeout) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        if (this.messages.size() <= 0 && this.isClosed) {
            throw new MessageStoreEOFException();
        }
        if (messageIdFilter == null) {
            return this.nextMessage();
        }
        boolean firstPass = true;
        if (timeout < 0) {
            timeout = 0;
        }
        while (this.messages.size() > 0 || !this.isClosed) {
            SshMessage msg = this.lookupMessage(messageIdFilter, true);
            if (msg != null) {
                return msg;
            }
            if (!firstPass && timeout > 0) {
                throw new MessageNotAvailableException();
            }
            if (!this.isClosed) {
                this.wait(timeout == 0 ? (long)this.interrupt : (long)timeout);
            }
            firstPass = false;
        }
        throw new MessageStoreEOFException();
    }

    public synchronized SshMessage getMessage(int messageId) throws MessageStoreEOFException, InterruptedException {
        try {
            return this.getMessage(messageId, 0);
        }
        catch (MessageNotAvailableException e) {
            throw new MessageStoreEOFException();
        }
    }

    public synchronized SshMessage getMessage(int messageId, int timeout) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        this.singleIdFilter[0] = messageId;
        return this.getMessage(this.singleIdFilter, timeout);
    }

    public boolean hasMessages() {
        return this.messages.size() > 0;
    }

    public int size() {
        return this.messages.size();
    }

    public boolean isRegisteredMessage(Integer messageId) {
        return this.register.containsKey(messageId);
    }

    public void addMessage(byte[] msgdata) throws MessageNotRegisteredException, InvalidMessageException, IOException {
        Integer messageId = new Integer(msgdata[5]);
        if (!this.isRegisteredMessage(messageId)) {
            throw new MessageNotRegisteredException(messageId);
        }
        Class cls = (Class)this.register.get(SshMessage.getMessageId(msgdata));
        try {
            SshMessage msg = (SshMessage)cls.newInstance();
            msg.fromByteArray(new ByteArrayReader(msgdata));
            this.addMessage(msg);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidMessageException("Illegal access for implementation class " + cls.getName());
        }
        catch (InstantiationException ie) {
            throw new InvalidMessageException("Instantiation failed for class " + cls.getName());
        }
    }

    public synchronized void addMessage(SshMessage msg) throws MessageNotRegisteredException, IOException {
        Integer id = new Integer(msg.getMessageId());
        if (this.asyncronous.containsKey(id)) {
            ((SshMessageListener)this.asyncronous.get(id)).onMessageReceived(msg);
        } else {
            this.messages.add(this.messages.size(), msg);
            this.notifyAll();
        }
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notifyAll();
    }

    public synchronized SshMessage nextMessage() throws MessageStoreEOFException, InterruptedException {
        if (this.messages.size() <= 0 && this.isClosed) {
            throw new MessageStoreEOFException();
        }
        while (this.messages.size() <= 0 && !this.isClosed) {
            this.wait(this.interrupt);
        }
        if (this.messages.size() > 0) {
            return (SshMessage)this.messages.remove(0);
        }
        throw new MessageStoreEOFException();
    }

    public synchronized void breakWaiting() {
        this.notifyAll();
    }

    public synchronized SshMessage peekMessage(int[] messageIdFilter) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        return this.peekMessage(messageIdFilter, 0);
    }

    public synchronized SshMessage peekMessage(int[] messageIdFilter, int timeout) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        SshMessage msg = this.lookupMessage(messageIdFilter, false);
        if (msg != null) {
            return msg;
        }
        if (timeout > 0) {
            if (log.isDebugEnabled()) {
                log.debug("No message so waiting for " + String.valueOf(timeout) + " milliseconds");
            }
            this.wait(timeout);
            msg = this.lookupMessage(messageIdFilter, false);
            if (msg != null) {
                return msg;
            }
        }
        if (this.isClosed) {
            throw new MessageStoreEOFException();
        }
        throw new MessageNotAvailableException();
    }

    private SshMessage lookupMessage(int[] messageIdFilter, boolean remove) {
        for (int x = 0; x < this.messages.size(); ++x) {
            SshMessage msg = (SshMessage)this.messages.get(x);
            for (int i = 0; i < messageIdFilter.length; ++i) {
                if (msg.getMessageId() != messageIdFilter[i]) continue;
                if (remove) {
                    this.messages.remove(msg);
                }
                return msg;
            }
        }
        return null;
    }

    public synchronized SshMessage peekMessage(int messageId) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        return this.peekMessage(messageId, 0);
    }

    public synchronized void removeMessage(SshMessage msg) {
        this.messages.remove(msg);
    }

    public synchronized SshMessage peekMessage(int messageId, int timeout) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        this.singleIdFilter[0] = messageId;
        return this.peekMessage(this.singleIdFilter, timeout);
    }

    public void registerMessage(int messageId, Class implementor) {
        Integer id = new Integer(messageId);
        this.register.put(id, implementor);
    }

    public void registerMessage(int messageId, Class implementor, SshMessageListener listener) {
        Integer id = new Integer(messageId);
        this.register.put(id, implementor);
        this.asyncronous.put(id, listener);
    }

    public Object[] getRegisteredMessageIds() {
        return this.register.keySet().toArray();
    }

    public SshMessage createMessage(byte[] msgdata) throws MessageNotRegisteredException, InvalidMessageException {
        Integer messageId = SshMessage.getMessageId(msgdata);
        if (!this.isRegisteredMessage(messageId)) {
            throw new MessageNotRegisteredException(messageId);
        }
        Class cls = (Class)this.register.get(SshMessage.getMessageId(msgdata));
        try {
            SshMessage msg = (SshMessage)cls.newInstance();
            msg.fromByteArray(new ByteArrayReader(msgdata));
            return msg;
        }
        catch (IllegalAccessException iae) {
            throw new InvalidMessageException("Illegal access for implementation class " + cls.getName());
        }
        catch (InstantiationException ie) {
            throw new InvalidMessageException("Instantiation failed for class " + cls.getName());
        }
    }
}

