/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import java.io.IOException;
import java.math.BigInteger;
import org.ietf.jgss.GSSContext;

public abstract class SshKeyExchange {
    protected BigInteger secret;
    protected byte[] exchangeHash;
    protected byte[] hostKey;
    protected byte[] signature;
    protected TransportProtocol transport;
    protected String hostname;
    protected GSSContext gssContext;
    protected SshConnectionProperties properties;

    public byte[] getExchangeHash() {
        return this.exchangeHash;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public BigInteger getSecret() {
        return this.secret;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public GSSContext getGSSContext() {
        return this.gssContext;
    }

    public void init(TransportProtocol transport, String hostname) throws IOException {
        this.transport = transport;
        this.hostname = hostname;
        this.onInit();
    }

    protected abstract void onInit() throws IOException;

    public abstract void performClientExchange(String var1, String var2, byte[] var3, byte[] var4, boolean var5, boolean var6, boolean var7) throws IOException;

    public abstract void performServerExchange(String var1, String var2, byte[] var3, byte[] var4, SshPrivateKey var5, boolean var6, boolean var7) throws IOException;

    public void reset() {
        this.exchangeHash = null;
        this.hostKey = null;
        this.signature = null;
        this.secret = null;
        this.gssContext = null;
    }

    void setProperties(SshConnectionProperties e) {
        this.properties = e;
    }
}

