/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPublicKeyFormatFactory {
    private static String defaultFormat;
    private static HashMap formatTypes;
    private static Log log;
    private static Vector types;

    public static void initialize() {
    }

    public static List getSupportedFormats() {
        return types;
    }

    public static SshPublicKeyFormat newInstance(String type) throws InvalidSshKeyException {
        try {
            if (formatTypes.containsKey(type)) {
                return (SshPublicKeyFormat)((Class)formatTypes.get(type)).newInstance();
            }
            throw new InvalidSshKeyException("The format type " + type + " is not supported");
        }
        catch (IllegalAccessException iae) {
            throw new InvalidSshKeyException("Illegal access to class implementation of " + type);
        }
        catch (InstantiationException ie) {
            throw new InvalidSshKeyException("Failed to create instance of format type " + type);
        }
    }

    public static String getDefaultFormatType() {
        return defaultFormat;
    }

    static {
        formatTypes = new HashMap();
        log = LogFactory.getLog(SshPublicKeyFormatFactory.class);
        types = new Vector();
        log.info("Loading public key formats");
        ArrayList<String> formats = new ArrayList<String>();
        formats.add(SECSHPublicKeyFormat.class.getName());
        formats.add(OpenSSHPublicKeyFormat.class.getName());
        defaultFormat = "SECSH-PublicKey-Base64Encoded";
        for (String classname : formats) {
            try {
                Class cls = ConfigurationLoader.getExtensionClass(classname);
                SshPublicKeyFormat f = (SshPublicKeyFormat)cls.newInstance();
                log.debug("Installing " + f.getFormatType() + " public key format");
                formatTypes.put(f.getFormatType(), cls);
                types.add(f.getFormatType());
            }
            catch (Throwable t) {
                log.warn("Public key format implemented by " + classname + " will not be available", t);
            }
        }
    }
}

