/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.dsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.util.SimpleASNWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshDssPublicKey
extends SshPublicKey {
    private static Log log = LogFactory.getLog(SshDssPublicKey.class);
    private DSAPublicKey pubkey;

    public SshDssPublicKey(DSAPublicKey key) {
        this.pubkey = key;
    }

    public SshDssPublicKey(byte[] key) throws InvalidSshKeyException {
        try {
            ByteArrayReader bar = new ByteArrayReader(key);
            String header = bar.readString();
            if (!header.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger p = bar.readBigInteger();
            BigInteger q = bar.readBigInteger();
            BigInteger g = bar.readBigInteger();
            BigInteger y = bar.readBigInteger();
            DSAPublicKeySpec dsaKey = new DSAPublicKeySpec(y, p, q, g);
            KeyFactory kf = KeyFactory.getInstance("DSA");
            this.pubkey = (DSAPublicKey)kf.generatePublic(dsaKey);
        }
        catch (Exception e) {
            throw new InvalidSshKeyException();
        }
    }

    @Override
    public String getAlgorithmName() {
        return "ssh-dss";
    }

    @Override
    public int getBitLength() {
        return this.pubkey.getY().bitLength();
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.writeString(this.getAlgorithmName());
            baw.writeBigInteger(this.pubkey.getParams().getP());
            baw.writeBigInteger(this.pubkey.getParams().getQ());
            baw.writeBigInteger(this.pubkey.getParams().getG());
            baw.writeBigInteger(this.pubkey.getY());
            return baw.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public boolean verifySignature(byte[] signature, byte[] data) throws InvalidSshKeySignatureException {
        try {
            if (signature.length != 40) {
                ByteArrayReader bar = new ByteArrayReader(signature);
                byte[] sig = bar.readBinaryString();
                String header = new String(sig);
                log.debug("Header is " + header);
                if (!header.equals("ssh-dss")) {
                    throw new InvalidSshKeySignatureException();
                }
                signature = bar.readBinaryString();
            }
            ByteArrayOutputStream r = new ByteArrayOutputStream();
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            SimpleASNWriter asn = new SimpleASNWriter();
            asn.writeByte(2);
            if ((signature[0] & 0x80) == 128 && signature[0] != 0) {
                r.write(0);
                r.write(signature, 0, 20);
            } else {
                r.write(signature, 0, 20);
            }
            asn.writeData(r.toByteArray());
            asn.writeByte(2);
            if ((signature[20] & 0x80) == 128 && signature[20] != 0) {
                s.write(0);
                s.write(signature, 20, 20);
            } else {
                s.write(signature, 20, 20);
            }
            asn.writeData(s.toByteArray());
            SimpleASNWriter asnEncoded = new SimpleASNWriter();
            asnEncoded.writeByte(48);
            asnEncoded.writeData(asn.toByteArray());
            byte[] encoded = asnEncoded.toByteArray();
            if (log.isDebugEnabled()) {
                int i;
                log.debug("Verifying host key signature");
                log.debug("Signature length is " + String.valueOf(signature.length));
                String hex = "";
                for (i = 0; i < signature.length; ++i) {
                    hex = hex + Integer.toHexString(signature[i] & 0xFF) + " ";
                }
                log.debug("SSH: " + hex);
                hex = "";
                for (i = 0; i < encoded.length; ++i) {
                    hex = hex + Integer.toHexString(encoded[i] & 0xFF) + " ";
                }
                log.debug("Encoded: " + hex);
            }
            Signature sig = Signature.getInstance("SHA1withDSA");
            sig.initVerify(this.pubkey);
            sig.update(data);
            return sig.verify(encoded);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidSshKeySignatureException();
        }
        catch (InvalidKeyException ike) {
            throw new InvalidSshKeySignatureException();
        }
        catch (IOException ioe) {
            throw new InvalidSshKeySignatureException();
        }
        catch (SignatureException se) {
            throw new InvalidSshKeySignatureException();
        }
    }
}

