/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.shift;

import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.shift.ShiftSessionPanel;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DirectoryListingTableModel
extends AbstractTableModel {
    public static final String FILENAME = "Name";
    public static final String SIZE = "Size";
    public static final String PERMISSIONS = "Rights";
    public static final String MODIFIED = "Modified";
    public static final String OWNER = "Owner";
    public static final String GROUP = "Group";
    List files;
    List icons;
    SftpClient sftp;
    Object lock = new Object();
    ShiftSessionPanel browser;
    String[] columnNames = new String[]{"Name", "Size", "Rights", "Modified", "Owner", "Group"};

    public DirectoryListingTableModel(SftpClient sftp) {
        this.sftp = sftp;
    }

    public String getCurrentDirectory() throws IOException {
        if (this.sftp != null && !this.sftp.isClosed()) {
            return this.sftp.pwd();
        }
        throw new IOException("The SFTP connection has been closed!");
    }

    public void createFolder(String foldername) throws IOException {
        if (this.sftp == null || this.sftp.isClosed()) {
            throw new IOException("The SFTP connection has been closed!");
        }
        this.sftp.mkdir(foldername);
        this.refresh();
    }

    public void removeFile(int row) throws IOException {
        this.sftp.rm(this.getFilename(row));
        this.files.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void removeFile(int[] row) throws IOException {
        for (int i = 0; i < row.length; ++i) {
            this.sftp.rm(this.getFilename(row[i]), true, true);
        }
        this.refresh();
    }

    public void changeDirectory(String directory) throws IOException {
        if (this.sftp == null || this.sftp.isClosed()) {
            throw new IOException("The SFTP connection has been closed!");
        }
        this.sftp.cd(directory);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectoryInternal(int row) {
        Object object = this.lock;
        synchronized (object) {
            if (row > this.files.size()) {
                throw new IndexOutOfBoundsException();
            }
            return (Boolean)this.icons.get(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(int row) {
        Object object = this.lock;
        synchronized (object) {
            if (row > this.files.size()) {
                throw new IndexOutOfBoundsException();
            }
            SftpFile file = (SftpFile)this.files.get(row);
            if (file.isLink()) {
                try {
                    String realPath = this.sftp.symlinkTarget(file.getAbsolutePath());
                    FileAttributes fattr = this.sftp.stat(realPath);
                    for (int n = 0; n < 5 && fattr.isLink(); ++n) {
                        realPath = this.sftp.symlinkTarget(realPath);
                        fattr = this.sftp.stat(realPath);
                    }
                    return fattr.isDirectory();
                    {
                    }
                }
                catch (IOException e) {
                    return false;
                }
            }
            return file.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileSize(int row) {
        Object object = this.lock;
        synchronized (object) {
            if (row > this.files.size()) {
                throw new IndexOutOfBoundsException();
            }
            SftpFile file = (SftpFile)this.files.get(row);
            return file.getAttributes().getSize().longValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilename(int row) {
        Object object = this.lock;
        synchronized (object) {
            if (row > this.files.size()) {
                throw new IndexOutOfBoundsException();
            }
            SftpFile file = (SftpFile)this.files.get(row);
            return file.getFilename();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileAttributes getFileAttributes(int row) {
        Object object = this.lock;
        synchronized (object) {
            if (row > this.files.size()) {
                throw new IndexOutOfBoundsException();
            }
            SftpFile file = (SftpFile)this.files.get(row);
            return file.getAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws IOException {
        if (this.sftp != null && !this.sftp.isClosed()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.files != null) {
                    this.fireTableRowsDeleted(1, this.files.size());
                    this.files.clear();
                }
                this.files = this.sftp.ls();
                Vector<SftpFile> remove = new Vector<SftpFile>();
                for (SftpFile f : this.files) {
                    if (!f.getFilename().equals(".") && !f.getFilename().equals("..")) continue;
                    remove.add(f);
                }
                this.files.removeAll(remove);
                Collections.sort(this.files, new FileComparator());
                this.icons = new LinkedList();
                for (int i = 0; i < this.files.size(); ++i) {
                    this.icons.add(i, new Boolean(this.isDirectory(i)));
                }
                this.fireTableRowsInserted(1, this.files.size());
            }
        } else {
            throw new IOException("The SFTP connection has been closed!");
        }
    }

    @Override
    public int getRowCount() {
        return this.files == null ? 0 : this.files.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object object = this.lock;
        synchronized (object) {
            SftpFile file = (SftpFile)this.files.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return file.getFilename();
                }
                case 1: {
                    return String.valueOf(file.getAttributes().getSize());
                }
                case 2: {
                    return file.getAttributes().getPermissionsString();
                }
                case 3: {
                    return file.getAttributes().getModTimeString();
                }
                case 4: {
                    return String.valueOf(file.getAttributes().getUID().longValue());
                }
                case 5: {
                    return String.valueOf(file.getAttributes().getGID().longValue());
                }
            }
            return "";
        }
    }

    class FileComparator
    implements Comparator {
        FileComparator() {
        }

        public int compare(Object o1, Object o2) {
            SftpFile f1 = (SftpFile)o1;
            SftpFile f2 = (SftpFile)o2;
            if (f1.isDirectory() && !f2.isDirectory()) {
                return -1;
            }
            if (f2.isDirectory() && !f1.isDirectory()) {
                return 1;
            }
            return f1.getFilename().compareTo(f2.getFilename());
        }
    }
}

