/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.sshvnc.SessionRecorder;
import com.sshtools.sshvnc.SocketFactory;
import com.sshtools.sshvnc.SshVNCViewer;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.Deflater;

class RfbProto {
    final String versionMsg = "RFB 003.003\n";
    static final int ConnFailed = 0;
    static final int NoAuth = 1;
    static final int VncAuth = 2;
    static final int VncAuthOK = 0;
    static final int VncAuthFailed = 1;
    static final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    final int SetPixelFormat = 0;
    final int FixColourMapEntries = 1;
    final int SetEncodings = 2;
    final int FramebufferUpdateRequest = 3;
    final int KeyboardEvent = 4;
    final int PointerEvent = 5;
    final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingCompressLevel0 = -256;
    static final int EncodingQualityLevel0 = -32;
    static final int EncodingXCursor = -240;
    static final int EncodingRichCursor = -239;
    static final int EncodingPointerPos = -232;
    static final int EncodingLastRect = -224;
    static final int EncodingNewFBSize = -223;
    static final int MaxNormalEncoding = 7;
    final int HextileRaw = 1;
    final int HextileBackgroundSpecified = 2;
    final int HextileForegroundSpecified = 4;
    final int HextileAnySubrects = 8;
    final int HextileSubrectsColoured = 16;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    static final int TightMinToCompress = 12;
    String host;
    int port;
    Socket sock;
    DataInputStream is;
    OutputStream os;
    SessionRecorder rec;
    boolean inNormalProtocol = false;
    SshVNCViewer viewer;
    boolean brokenKeyPressed = false;
    boolean wereZlibUpdates = false;
    boolean recordFromBeginning = true;
    boolean zlibWarningShown;
    boolean tightWarningShown;
    int numUpdatesInSession;
    private boolean closed;
    int serverMajor;
    int serverMinor;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 4;
    static final int ALT_MASK = 8;
    int pointerMask = 0;
    int oldModifiers = 0;

    RfbProto(String h, int p, SshVNCViewer v) throws IOException {
        this.viewer = v;
        this.host = h;
        this.port = p;
        if (this.viewer.getSocketFactory() == null) {
            this.sock = new Socket(this.host, this.port);
        } else {
            try {
                Class<?> factoryClass = Class.forName(this.viewer.getSocketFactory());
                SocketFactory factory = (SocketFactory)factoryClass.newInstance();
                this.sock = factory.createSocket(this.host, this.port, this.viewer);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
    }

    RfbProto(InputStream in, OutputStream out, SshVNCViewer v) throws IOException {
        this.viewer = v;
        this.is = new DataInputStream(new BufferedInputStream(in, 16384));
        this.os = out;
    }

    synchronized void close() {
        try {
            if (this.sock != null) {
                this.sock.close();
            } else {
                try {
                    if (this.is != null) {
                        this.is.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.closed = true;
            System.out.println("RFB socket closed");
            if (this.rec != null) {
                this.rec.close();
                this.rec = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized boolean closed() {
        return this.closed;
    }

    void readVersionMsg() throws Exception {
        byte[] b = new byte[12];
        this.is.readFully(b);
        if (b[0] != 82 || b[1] != 70 || b[2] != 66 || b[3] != 32 || b[4] < 48 || b[4] > 57 || b[5] < 48 || b[5] > 57 || b[6] < 48 || b[6] > 57 || b[7] != 46 || b[8] < 48 || b[8] > 57 || b[9] < 48 || b[9] > 57 || b[10] < 48 || b[10] > 57 || b[11] != 10) {
            if (this.sock != null) {
                throw new Exception("Host " + this.host + " port " + this.port + " is not an RFB server");
            }
            throw new Exception("Streams are not connected to an RFB server");
        }
        this.serverMajor = (b[4] - 48) * 100 + (b[5] - 48) * 10 + (b[6] - 48);
        this.serverMinor = (b[8] - 48) * 100 + (b[9] - 48) * 10 + (b[10] - 48);
    }

    void writeVersionMsg() throws IOException {
        this.os.write("RFB 003.003\n".getBytes());
    }

    int readAuthScheme() throws Exception {
        int authScheme = this.is.readInt();
        switch (authScheme) {
            case 0: {
                int reasonLen = this.is.readInt();
                byte[] reason = new byte[reasonLen];
                this.is.readFully(reason);
                throw new Exception(new String(reason));
            }
            case 1: 
            case 2: {
                return authScheme;
            }
        }
        throw new Exception("Unknown authentication scheme from RFB server: " + authScheme);
    }

    void writeClientInit() throws IOException {
        if (this.viewer.getOptions().isShareDesktop()) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] pad = new byte[3];
        this.is.readFully(pad);
        int nameLength = this.is.readInt();
        byte[] name = new byte[nameLength];
        this.is.readFully(name);
        this.desktopName = new String(name);
        this.inNormalProtocol = true;
    }

    void startSession(String fname) throws IOException {
        this.rec = new SessionRecorder(fname);
        this.rec.writeHeader();
        this.rec.write("RFB 003.003\n".getBytes());
        this.rec.writeIntBE(1);
        this.rec.writeShortBE(this.framebufferWidth);
        this.rec.writeShortBE(this.framebufferHeight);
        byte[] fbsServerInitMsg = new byte[]{32, 24, 0, 1, 0, -1, 0, -1, 0, -1, 16, 8, 0, 0, 0, 0};
        this.rec.write(fbsServerInitMsg);
        this.rec.writeIntBE(this.desktopName.length());
        this.rec.write(this.desktopName.getBytes());
        this.numUpdatesInSession = 0;
        if (this.wereZlibUpdates) {
            this.recordFromBeginning = false;
        }
        this.zlibWarningShown = false;
        this.tightWarningShown = false;
    }

    void closeSession() throws IOException {
        if (this.rec != null) {
            this.rec.close();
            this.rec = null;
        }
    }

    void setFramebufferSize(int width, int height) {
        this.framebufferWidth = width;
        this.framebufferHeight = height;
    }

    int readServerMessageType() throws IOException {
        int msgType = this.is.readUnsignedByte();
        if (this.rec != null && msgType == 2) {
            this.rec.writeByte(msgType);
            if (this.numUpdatesInSession > 0) {
                this.rec.flush();
            }
        }
        return msgType;
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeByte(0);
            this.rec.writeByte(0);
            this.rec.writeShortBE(this.updateNRects);
        }
        ++this.numUpdatesInSession;
    }

    void readFramebufferUpdateRectHdr() throws Exception {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectEncoding == 6 || this.updateRectEncoding == 7) {
            this.wereZlibUpdates = true;
        }
        if (this.rec != null) {
            if (this.numUpdatesInSession > 1) {
                this.rec.flush();
            }
            this.rec.writeShortBE(this.updateRectX);
            this.rec.writeShortBE(this.updateRectY);
            this.rec.writeShortBE(this.updateRectW);
            this.rec.writeShortBE(this.updateRectH);
            if (this.updateRectEncoding == 6 && !this.recordFromBeginning) {
                if (!this.zlibWarningShown) {
                    System.out.println("Warning: Raw encoding will be used instead of Zlib in recorded session.");
                    this.zlibWarningShown = true;
                }
                this.rec.writeIntBE(0);
            } else {
                this.rec.writeIntBE(this.updateRectEncoding);
                if (this.updateRectEncoding == 7 && !this.recordFromBeginning && !this.tightWarningShown) {
                    System.out.println("Warning: Re-compressing Tight-encoded updates for session recording.");
                    this.tightWarningShown = true;
                }
            }
        }
        if (this.updateRectEncoding < 0 || this.updateRectEncoding > 7) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new Exception("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeShortBE(this.copyRectSrcX);
            this.rec.writeShortBE(this.copyRectSrcY);
        }
    }

    String readServerCutText() throws IOException {
        byte[] pad = new byte[3];
        this.is.readFully(pad);
        int len = this.is.readInt();
        byte[] text = new byte[len];
        this.is.readFully(text);
        return new String(text);
    }

    int readCompactLen() throws IOException {
        int[] portion = new int[3];
        portion[0] = this.is.readUnsignedByte();
        int byteCount = 1;
        int len = portion[0] & 0x7F;
        if ((portion[0] & 0x80) != 0) {
            portion[1] = this.is.readUnsignedByte();
            ++byteCount;
            len |= (portion[1] & 0x7F) << 7;
            if ((portion[1] & 0x80) != 0) {
                portion[2] = this.is.readUnsignedByte();
                ++byteCount;
                len |= (portion[2] & 0xFF) << 14;
            }
        }
        if (this.rec != null && this.recordFromBeginning) {
            for (int i = 0; i < byteCount; ++i) {
                this.rec.writeByte(portion[i]);
            }
        }
        return len;
    }

    void writeFramebufferUpdateRequest(int x, int y, int w, int h, boolean incremental) throws IOException {
        byte[] b = new byte[]{3, (byte)(incremental ? 1 : 0), (byte)(x >> 8 & 0xFF), (byte)(x & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(w >> 8 & 0xFF), (byte)(w & 0xFF), (byte)(h >> 8 & 0xFF), (byte)(h & 0xFF)};
        this.os.write(b);
    }

    void writeSetPixelFormat(int bitsPerPixel, int depth, boolean bigEndian, boolean trueColour, int redMax, int greenMax, int blueMax, int redShift, int greenShift, int blueShift) throws IOException {
        byte[] b = new byte[20];
        b[0] = 0;
        b[4] = (byte)bitsPerPixel;
        b[5] = (byte)depth;
        b[6] = (byte)(bigEndian ? 1 : 0);
        b[7] = (byte)(trueColour ? 1 : 0);
        b[8] = (byte)(redMax >> 8 & 0xFF);
        b[9] = (byte)(redMax & 0xFF);
        b[10] = (byte)(greenMax >> 8 & 0xFF);
        b[11] = (byte)(greenMax & 0xFF);
        b[12] = (byte)(blueMax >> 8 & 0xFF);
        b[13] = (byte)(blueMax & 0xFF);
        b[14] = (byte)redShift;
        b[15] = (byte)greenShift;
        b[16] = (byte)blueShift;
        this.os.write(b);
    }

    void writeFixColourMapEntries(int firstColour, int nColours, int[] red, int[] green, int[] blue) throws IOException {
        byte[] b = new byte[6 + nColours * 6];
        b[0] = 1;
        b[2] = (byte)(firstColour >> 8 & 0xFF);
        b[3] = (byte)(firstColour & 0xFF);
        b[4] = (byte)(nColours >> 8 & 0xFF);
        b[5] = (byte)(nColours & 0xFF);
        for (int i = 0; i < nColours; ++i) {
            b[6 + i * 6] = (byte)(red[i] >> 8 & 0xFF);
            b[6 + i * 6 + 1] = (byte)(red[i] & 0xFF);
            b[6 + i * 6 + 2] = (byte)(green[i] >> 8 & 0xFF);
            b[6 + i * 6 + 3] = (byte)(green[i] & 0xFF);
            b[6 + i * 6 + 4] = (byte)(blue[i] >> 8 & 0xFF);
            b[6 + i * 6 + 5] = (byte)(blue[i] & 0xFF);
        }
        this.os.write(b);
    }

    void writeSetEncodings(int[] encs, int len) throws IOException {
        byte[] b = new byte[4 + 4 * len];
        b[0] = 2;
        b[2] = (byte)(len >> 8 & 0xFF);
        b[3] = (byte)(len & 0xFF);
        for (int i = 0; i < len; ++i) {
            b[4 + 4 * i] = (byte)(encs[i] >> 24 & 0xFF);
            b[5 + 4 * i] = (byte)(encs[i] >> 16 & 0xFF);
            b[6 + 4 * i] = (byte)(encs[i] >> 8 & 0xFF);
            b[7 + 4 * i] = (byte)(encs[i] & 0xFF);
        }
        this.os.write(b);
    }

    void writeClientCutText(String text) throws IOException {
        byte[] b = new byte[8 + text.length()];
        b[0] = 6;
        b[4] = (byte)(text.length() >> 24 & 0xFF);
        b[5] = (byte)(text.length() >> 16 & 0xFF);
        b[6] = (byte)(text.length() >> 8 & 0xFF);
        b[7] = (byte)(text.length() & 0xFF);
        System.arraycopy(text.getBytes(), 0, b, 8, text.length());
        this.os.write(b);
    }

    void writePointerEvent(MouseEvent evt) throws IOException {
        int modifiers = evt.getModifiers();
        int mask2 = 2;
        int mask3 = 4;
        if (this.viewer.getOptions().isReverseMouseButtons2And3()) {
            mask2 = 4;
            mask3 = 2;
        }
        if (evt.getID() == 501) {
            if ((modifiers & 8) != 0) {
                this.pointerMask = mask2;
                modifiers &= 0xFFFFFFF7;
            } else if ((modifiers & 4) != 0) {
                this.pointerMask = mask3;
                modifiers &= 0xFFFFFFFB;
            } else {
                this.pointerMask = 1;
            }
        } else if (evt.getID() == 502) {
            this.pointerMask = 0;
            if ((modifiers & 8) != 0) {
                modifiers &= 0xFFFFFFF7;
            } else if ((modifiers & 4) != 0) {
                modifiers &= 0xFFFFFFFB;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(modifiers);
        int x = evt.getX();
        int y = evt.getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
        this.eventBuf[this.eventBufLen++] = (byte)(x >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(x & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(y >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(y & 0xFF);
        if (this.pointerMask == 0) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(KeyEvent evt) throws IOException {
        int key;
        boolean down;
        block44: {
            int keyChar;
            block43: {
                int code;
                keyChar = evt.getKeyChar();
                if (keyChar == 0) {
                    keyChar = 65535;
                }
                if (keyChar == 65535 && ((code = evt.getKeyCode()) == 17 || code == 16 || code == 157 || code == 18)) {
                    return;
                }
                boolean bl = down = evt.getID() == 401;
                if (!evt.isActionKey()) break block43;
                switch (evt.getKeyCode()) {
                    case 36: {
                        key = 65360;
                        break block44;
                    }
                    case 37: {
                        key = 65361;
                        break block44;
                    }
                    case 38: {
                        key = 65362;
                        break block44;
                    }
                    case 39: {
                        key = 65363;
                        break block44;
                    }
                    case 40: {
                        key = 65364;
                        break block44;
                    }
                    case 33: {
                        key = 65365;
                        break block44;
                    }
                    case 34: {
                        key = 65366;
                        break block44;
                    }
                    case 35: {
                        key = 65367;
                        break block44;
                    }
                    case 155: {
                        key = 65379;
                        break block44;
                    }
                    case 112: {
                        key = 65470;
                        break block44;
                    }
                    case 113: {
                        key = 65471;
                        break block44;
                    }
                    case 114: {
                        key = 65472;
                        break block44;
                    }
                    case 115: {
                        key = 65473;
                        break block44;
                    }
                    case 116: {
                        key = 65474;
                        break block44;
                    }
                    case 117: {
                        key = 65475;
                        break block44;
                    }
                    case 118: {
                        key = 65476;
                        break block44;
                    }
                    case 119: {
                        key = 65477;
                        break block44;
                    }
                    case 120: {
                        key = 65478;
                        break block44;
                    }
                    case 121: {
                        key = 65479;
                        break block44;
                    }
                    case 122: {
                        key = 65480;
                        break block44;
                    }
                    case 123: {
                        key = 65481;
                        break block44;
                    }
                    default: {
                        return;
                    }
                }
            }
            key = keyChar;
            if (key < 32) {
                if (evt.isControlDown()) {
                    key += 96;
                } else {
                    switch (key) {
                        case 8: {
                            key = 65288;
                            break;
                        }
                        case 9: {
                            key = 65289;
                            break;
                        }
                        case 10: {
                            key = 65293;
                            break;
                        }
                        case 27: {
                            key = 65307;
                        }
                    }
                }
            } else if (key == 127) {
                key = 65535;
            } else if (key > 255 && (key < 65280 || key > 65535)) {
                return;
            }
        }
        if (key == 229 || key == 197 || key == 228 || key == 196 || key == 246 || key == 214 || key == 167 || key == 189 || key == 163) {
            if (down) {
                this.brokenKeyPressed = true;
            }
            if (!down && !this.brokenKeyPressed) {
                this.eventBufLen = 0;
                this.writeModifierKeyEvents(evt.getModifiers());
                this.writeKeyEvent(key, true);
                this.os.write(this.eventBuf, 0, this.eventBufLen);
            }
            if (!down) {
                this.brokenKeyPressed = false;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(evt.getModifiers());
        this.writeKeyEvent(key, down);
        if (!down) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(int keysym, boolean down) {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(down ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym & 0xFF);
    }

    void writeModifierKeyEvents(int newModifiers) {
        if ((newModifiers & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (newModifiers & 2) != 0);
        }
        if ((newModifiers & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (newModifiers & 1) != 0);
        }
        if ((newModifiers & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (newModifiers & 4) != 0);
        }
        if ((newModifiers & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (newModifiers & 8) != 0);
        }
        this.oldModifiers = newModifiers;
    }

    void recordCompressedData(byte[] data, int off, int len) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(data, off, len);
        int bufSize = len + len / 100 + 12;
        byte[] buf = new byte[bufSize];
        deflater.finish();
        int compressedSize = deflater.deflate(buf);
        this.recordCompactLen(compressedSize);
        this.rec.write(buf, 0, compressedSize);
    }

    void recordCompressedData(byte[] data) throws IOException {
        this.recordCompressedData(data, 0, data.length);
    }

    void recordCompactLen(int len) throws IOException {
        byte[] buf = new byte[3];
        int bytes = 0;
        buf[bytes++] = (byte)(len & 0x7F);
        if (len > 127) {
            int n = bytes - 1;
            buf[n] = (byte)(buf[n] | 0x80);
            buf[bytes++] = (byte)(len >> 7 & 0x7F);
            if (len > 16383) {
                int n2 = bytes - 1;
                buf[n2] = (byte)(buf[n2] | 0x80);
                buf[bytes++] = (byte)(len >> 14 & 0xFF);
            }
        }
        this.rec.write(buf, 0, bytes);
    }
}

