/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.tunnel;

import com.sshtools.j2ssh.forwarding.ForwardingChannel;
import com.sshtools.tunnel.ActiveChannelWrapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;

public class ActiveChannelModel
extends AbstractTableModel {
    private Vector active = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveChannel(ForwardingChannel channel) {
        Vector vector = this.active;
        synchronized (vector) {
            int r = this.getRowCount();
            this.active.addElement(new ActiveChannelWrapper(channel));
            this.fireTableRowsInserted(r, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveChannel(ForwardingChannel channel) {
        Vector vector = this.active;
        synchronized (vector) {
            int idx = this.indexOf(channel);
            if (idx != -1) {
                this.active.removeElementAt(idx);
                this.fireTableRowsDeleted(idx, idx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dataSent(ForwardingChannel channel) {
        final int i = this.indexOf(channel);
        Vector vector = this.active;
        synchronized (vector) {
            try {
                if (i != -1) {
                    final ActiveChannelWrapper w = (ActiveChannelWrapper)this.active.elementAt(i);
                    if (w.getSentTimer() == null) {
                        w.setSentTimer(new Timer(500, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                w.setSending(false);
                                ActiveChannelModel.this.fireTableRowsUpdated(i, i);
                            }
                        }));
                        w.getSentTimer().setRepeats(false);
                    }
                    if (!w.getSentTimer().isRunning()) {
                        w.setSending(true);
                        this.fireTableRowsUpdated(i, i);
                        w.getSentTimer().start();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dataReceived(ForwardingChannel channel) {
        final int i = this.indexOf(channel);
        Vector vector = this.active;
        synchronized (vector) {
            try {
                if (i != -1) {
                    final ActiveChannelWrapper w = (ActiveChannelWrapper)this.active.elementAt(i);
                    if (w.getReceivedTimer() == null) {
                        w.setReceivedTimer(new Timer(500, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                w.setReceiving(false);
                                ActiveChannelModel.this.fireTableRowsUpdated(i, i);
                            }
                        }));
                        w.getReceivedTimer().setRepeats(false);
                    }
                    if (!w.getReceivedTimer().isRunning()) {
                        w.setReceiving(true);
                        this.fireTableRowsUpdated(i, i);
                        w.getReceivedTimer().start();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActiveChannel(ForwardingChannel channel) {
        Vector vector = this.active;
        synchronized (vector) {
            int idx = this.indexOf(channel);
            if (idx != -1) {
                this.fireTableRowsUpdated(idx, idx);
            }
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return "SD";
            }
            case 1: {
                return "RD";
            }
            case 2: {
                return "Name";
            }
        }
        return "Host";
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Vector vector = this.active;
        synchronized (vector) {
            return this.active.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Vector vector = this.active;
        synchronized (vector) {
            this.active.removeAllElements();
        }
    }

    public Iterator activeChannels() {
        return this.active.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int r, int c) {
        Vector vector = this.active;
        synchronized (vector) {
            ActiveChannelWrapper w = null;
            try {
                w = (ActiveChannelWrapper)this.active.elementAt(r);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                // empty catch block
            }
            switch (c) {
                case 0: {
                    if (w != null) {
                        return new Boolean(w.isSending());
                    }
                    return new Boolean(false);
                }
                case 1: {
                    if (w != null) {
                        return new Boolean(w.isReceiving());
                    }
                    return new Boolean(false);
                }
                case 2: {
                    if (w != null) {
                        return new String(w.getChannel().getName());
                    }
                    return new Long(-1L);
                }
            }
            if (w != null) {
                StringBuffer sb = new StringBuffer(w.getChannel().getOriginatingHost());
                sb.append(":");
                sb.append(w.getChannel().getOriginatingPort());
                return sb.toString();
            }
            return "Removed";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int indexOf(ForwardingChannel channel) {
        Vector vector = this.active;
        synchronized (vector) {
            int j = this.active.size();
            try {
                for (int i = 0; i < j; ++i) {
                    ActiveChannelWrapper a = (ActiveChannelWrapper)this.active.elementAt(i);
                    if (a.getChannel() != channel) continue;
                    return i;
                }
                return -1;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActiveChannelWrapper findWrapper(ForwardingChannel channel) {
        Vector vector = this.active;
        synchronized (vector) {
            int j = this.active.size();
            for (int i = 0; i < j; ++i) {
                try {
                    ActiveChannelWrapper a = (ActiveChannelWrapper)this.active.elementAt(i);
                    if (a.getChannel() != channel) continue;
                    return a;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    return null;
                }
            }
        }
        return null;
    }
}

