/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.hep.dcapj.util;

import edu.caltech.hep.dcapj.Config;
import edu.caltech.hep.dcapj.PnfsUtil;
import edu.caltech.hep.dcapj.dCapLayer;
import edu.caltech.hep.dcapj.util.ControlCommandCallback;
import edu.caltech.hep.dcapj.util.InvalidConfigurationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Hashtable;
import java.util.logging.Logger;

public class ControlConnection
implements Runnable {
    private static final Logger _logger = Logger.getLogger(ControlConnection.class.getName());
    protected Hashtable<Integer, ControlCommandCallback> callbacks;
    private Socket _client = null;
    private PrintWriter _clientOut = null;
    private BufferedReader _clientIn = null;
    private boolean _shouldBeRunning = true;
    private boolean _stopped = true;
    private Thread _clientThread = null;
    private Integer _nextSessionID = -1;

    public ControlConnection() throws IOException, InvalidConfigurationException {
        this.initialize();
    }

    private void initialize() throws IOException, InvalidConfigurationException {
        String[] tmp;
        Config conf = dCapLayer.getConfig();
        if (conf == null) {
            String emsg = "Configuration object was null";
            throw new InvalidConfigurationException(emsg);
        }
        String dCapHost = conf.getdCapDoor();
        if (dCapHost == null) {
            _logger.fine("No defautl dCap host defined. dCapJ will try to find  it through pnfs layer");
            try {
                dCapHost = PnfsUtil.getdCapDoor(conf.getPnfsDir() == null ? "/pnfs/fs/usr/data" : conf.getPnfsDir());
            }
            catch (Exception e) {
                _logger.finest(e.getMessage());
            }
        }
        String ip = null;
        int port = -1;
        if (dCapHost != null && (tmp = dCapHost.split(":")).length > 1) {
            ip = tmp[0];
            try {
                System.out.println(tmp[1]);
                port = Integer.parseInt(tmp[1]);
            }
            catch (NumberFormatException nfe) {
                _logger.severe("Illegal port number in dCap host address");
            }
        }
        if (ip == null || port == -1) {
            InvalidConfigurationException invc = new InvalidConfigurationException("dCap door host and port are not properly defined.");
            _logger.throwing("ControlConnection", "initialize", invc);
            throw invc;
        }
        _logger.fine("Connection to dCap door at " + ip + ":port");
        this._client = new Socket(ip, port);
        this._clientOut = new PrintWriter(this._client.getOutputStream());
        this._clientIn = new BufferedReader(new InputStreamReader(this._client.getInputStream()));
        _logger.finer("IO streams initialized for dCap door");
        this.doHelloConversation();
        this.callbacks = new Hashtable();
        this.start();
    }

    private void doHelloConversation() throws IOException {
        this.sendCommand("0 0 client hello 0 0 1 1");
        String reply = this._clientIn.readLine();
        String[] doorReply = null;
        if (reply != null) {
            doorReply = reply.split(" ");
        }
        if (doorReply == null || doorReply.length < 4) {
            throw new IOException("Not a valid reply from dcap door; where reply = " + doorReply);
        }
        if (doorReply[3].equals("welcome")) {
            _logger.fine("dCap door replied: " + doorReply[3]);
        } else {
            if (doorReply[3].equals("failed")) {
                _logger.severe("dCap door rejected connection!");
                this.sendCommand("0 0 client byebye");
                throw new IOException("Error Code: " + (doorReply.length > 5 ? doorReply[4] : "Unknown") + " Error Message: " + (doorReply.length > 6 ? doorReply[5] : " Unknown"));
            }
            if (doorReply[3].equals("byebye")) {
                _logger.severe("dCap door closed connection.");
                throw new IOException("Failed to initialize dCap door");
            }
        }
    }

    @Override
    public void run() {
        String reply = null;
        while (this._shouldBeRunning) {
            try {
                Thread.sleep(500L);
                if (!this._clientIn.ready()) continue;
                reply = this._clientIn.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            if (reply == null) {
                _logger.warning("Received null in command loop ");
                break;
            }
            _logger.finer("Received command reply: \"" + reply + "\"");
            String[] replyParts = reply.split(" ");
            if (replyParts.length <= 0) continue;
            int session = -1;
            try {
                session = Integer.parseInt(replyParts[0]);
            }
            catch (NumberFormatException nfe) {
                _logger.warning("Failed to parse door reply to get session ID " + replyParts[0]);
            }
            ControlCommandCallback ccc = this.callbacks.get(session);
            if (ccc != null) {
                ccc.handleDoorCommand(replyParts);
                _logger.fine("Notified session " + session + " for command callback");
                continue;
            }
            _logger.warning("No callback registered/found for session " + session);
        }
        try {
            this._clientIn.close();
            this._clientOut.close();
            this._client.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._stopped = true;
    }

    protected void start() {
        if (this._clientThread == null) {
            this._shouldBeRunning = true;
            this._clientThread = new Thread(this);
            this._clientThread.setName("Server");
            this._clientThread.start();
        }
    }

    public void stop() {
        this._shouldBeRunning = false;
        _logger.fine("Closting control connection");
        try {
            this._clientThread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isStopped() {
        return this._stopped;
    }

    public boolean registerCallback(int sessionID, ControlCommandCallback ccc) {
        if (!this.callbacks.contains(sessionID)) {
            this.callbacks.put(sessionID, ccc);
            _logger.fine("Registered command call back receiver for sessionID " + sessionID);
            return true;
        }
        return false;
    }

    public boolean unregisterCallback(int sessionID) {
        if (this.callbacks.contains(sessionID)) {
            _logger.info("Removing callback receiver for sessionID " + sessionID);
            this.callbacks.remove(sessionID);
            return true;
        }
        return false;
    }

    public void sendCommand(String command) throws IOException {
        this._clientOut.println(command);
        this._clientOut.flush();
        _logger.finer("Sent command: \"" + command + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextSessionID() {
        int temp = -1;
        Integer n = this._nextSessionID;
        synchronized (n) {
            this._nextSessionID = this._nextSessionID + 1;
            temp = this._nextSessionID;
        }
        return temp;
    }
}

