/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.cms;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OctetString;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1TaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.BERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.BERTaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedContentInfo
extends ASN1Encodable {
    private DERObjectIdentifier contentType;
    private AlgorithmIdentifier contentEncryptionAlgorithm;
    private ASN1OctetString encryptedContent;

    public EncryptedContentInfo(DERObjectIdentifier dERObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString) {
        this.contentType = dERObjectIdentifier;
        this.contentEncryptionAlgorithm = algorithmIdentifier;
        this.encryptedContent = aSN1OctetString;
    }

    public EncryptedContentInfo(ASN1Sequence aSN1Sequence) {
        this.contentType = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        this.contentEncryptionAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() > 2) {
            this.encryptedContent = ASN1OctetString.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(2), false);
        }
    }

    public static EncryptedContentInfo getInstance(Object object) {
        if (object == null || object instanceof EncryptedContentInfo) {
            return (EncryptedContentInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new EncryptedContentInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid EncryptedContentInfo: " + object.getClass().getName());
    }

    public DERObjectIdentifier getContentType() {
        return this.contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public ASN1OctetString getEncryptedContent() {
        return this.encryptedContent;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.contentType);
        aSN1EncodableVector.add(this.contentEncryptionAlgorithm);
        if (this.encryptedContent != null) {
            aSN1EncodableVector.add(new BERTaggedObject(false, 0, this.encryptedContent));
        }
        return new BERSequence(aSN1EncodableVector);
    }
}

