/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class InputStreamTest
extends SimpleTest {
    private static final byte[] outOfBoundsLength = new byte[]{48, -1, -1, -1, -1, -1};
    private static final byte[] negativeLength = new byte[]{48, -124, -1, -1, -1, -1};
    private static final byte[] outsideLimitLength = new byte[]{48, -125, 15, -1, -1};

    public String getName() {
        return "InputStream";
    }

    public void performTest() throws Exception {
        block8: {
            ASN1InputStream aSN1InputStream;
            block7: {
                block6: {
                    aSN1InputStream = new ASN1InputStream(outOfBoundsLength);
                    try {
                        aSN1InputStream.readObject();
                        this.fail("out of bounds length not detected.");
                    }
                    catch (IOException iOException) {
                        if (iOException.getMessage().startsWith("DER length more than 4 bytes")) break block6;
                        this.fail("wrong exception: " + iOException.getMessage());
                    }
                }
                aSN1InputStream = new ASN1InputStream(negativeLength);
                try {
                    aSN1InputStream.readObject();
                    this.fail("negative length not detected.");
                }
                catch (IOException iOException) {
                    if (iOException.getMessage().equals("corrupted stream - negative length found")) break block7;
                    this.fail("wrong exception: " + iOException.getMessage());
                }
            }
            aSN1InputStream = new ASN1InputStream(outsideLimitLength);
            try {
                aSN1InputStream.readObject();
                this.fail("outside limit length not detected.");
            }
            catch (IOException iOException) {
                if (iOException.getMessage().equals("corrupted stream - out of bounds length found")) break block8;
                this.fail("wrong exception: " + iOException.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        InputStreamTest.runTest(new InputStreamTest());
    }
}

