/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.ess.OtherCertID;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x509.AlgorithmIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.x509.GeneralName;
import edu.illinois.ncsa.bouncycastle.asn1.x509.GeneralNames;
import edu.illinois.ncsa.bouncycastle.asn1.x509.IssuerSerial;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509Name;
import java.io.IOException;

public class OtherCertIDUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "OtherCertID";
    }

    public void performTest() throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.2.3"));
        byte[] byArray = new byte[20];
        IssuerSerial issuerSerial = new IssuerSerial(new GeneralNames(new GeneralName(new X509Name("CN=test"))), new DERInteger(1));
        OtherCertID otherCertID = new OtherCertID(algorithmIdentifier, byArray);
        this.checkConstruction(otherCertID, algorithmIdentifier, byArray, null);
        otherCertID = new OtherCertID(algorithmIdentifier, byArray, issuerSerial);
        this.checkConstruction(otherCertID, algorithmIdentifier, byArray, issuerSerial);
        otherCertID = OtherCertID.getInstance(null);
        if (otherCertID != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            OtherCertID.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(OtherCertID otherCertID, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, IssuerSerial issuerSerial) throws IOException {
        this.checkValues(otherCertID, algorithmIdentifier, byArray, issuerSerial);
        otherCertID = OtherCertID.getInstance(otherCertID);
        this.checkValues(otherCertID, algorithmIdentifier, byArray, issuerSerial);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(otherCertID.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        otherCertID = OtherCertID.getInstance(aSN1Sequence);
        this.checkValues(otherCertID, algorithmIdentifier, byArray, issuerSerial);
    }

    private void checkValues(OtherCertID otherCertID, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, IssuerSerial issuerSerial) {
        this.checkMandatoryField("algorithmHash", algorithmIdentifier, otherCertID.getAlgorithmHash());
        this.checkMandatoryField("certHash", byArray, otherCertID.getCertHash());
        this.checkOptionalField("issuerSerial", issuerSerial, otherCertID.getIssuerSerial());
    }

    public static void main(String[] stringArray) {
        OtherCertIDUnitTest.runTest(new OtherCertIDUnitTest());
    }
}

