/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.x509;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERGeneralizedTime;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;

public class AttCertValidityPeriod
extends ASN1Encodable {
    DERGeneralizedTime notBeforeTime;
    DERGeneralizedTime notAfterTime;

    public static AttCertValidityPeriod getInstance(Object object) {
        if (object instanceof AttCertValidityPeriod) {
            return (AttCertValidityPeriod)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AttCertValidityPeriod((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public AttCertValidityPeriod(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.notBeforeTime = DERGeneralizedTime.getInstance(aSN1Sequence.getObjectAt(0));
        this.notAfterTime = DERGeneralizedTime.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public AttCertValidityPeriod(DERGeneralizedTime dERGeneralizedTime, DERGeneralizedTime dERGeneralizedTime2) {
        this.notBeforeTime = dERGeneralizedTime;
        this.notAfterTime = dERGeneralizedTime2;
    }

    public DERGeneralizedTime getNotBeforeTime() {
        return this.notBeforeTime;
    }

    public DERGeneralizedTime getNotAfterTime() {
        return this.notAfterTime;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.notBeforeTime);
        aSN1EncodableVector.add(this.notAfterTime);
        return new DERSequence(aSN1EncodableVector);
    }
}

