/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.x9;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OctetString;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import java.util.Enumeration;

public class KeySpecificInfo
extends ASN1Encodable {
    private DERObjectIdentifier algorithm;
    private ASN1OctetString counter;

    public KeySpecificInfo(DERObjectIdentifier dERObjectIdentifier, ASN1OctetString aSN1OctetString) {
        this.algorithm = dERObjectIdentifier;
        this.counter = aSN1OctetString;
    }

    public KeySpecificInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.algorithm = (DERObjectIdentifier)enumeration.nextElement();
        this.counter = (ASN1OctetString)enumeration.nextElement();
    }

    public DERObjectIdentifier getAlgorithm() {
        return this.algorithm;
    }

    public ASN1OctetString getCounter() {
        return this.counter;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.algorithm);
        aSN1EncodableVector.add(this.counter);
        return new DERSequence(aSN1EncodableVector);
    }
}

