/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.bcpg;

import edu.illinois.ncsa.bouncycastle.bcpg.BCPGInputStream;
import edu.illinois.ncsa.bouncycastle.bcpg.BCPGOutputStream;
import edu.illinois.ncsa.bouncycastle.bcpg.ContainedPacket;
import edu.illinois.ncsa.bouncycastle.bcpg.UserAttributeSubpacket;
import edu.illinois.ncsa.bouncycastle.bcpg.UserAttributeSubpacketInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

public class UserAttributePacket
extends ContainedPacket {
    private UserAttributeSubpacket[] subpackets;

    public UserAttributePacket(BCPGInputStream bCPGInputStream) throws IOException {
        UserAttributeSubpacket userAttributeSubpacket;
        UserAttributeSubpacketInputStream userAttributeSubpacketInputStream = new UserAttributeSubpacketInputStream(bCPGInputStream);
        Vector<UserAttributeSubpacket> vector = new Vector<UserAttributeSubpacket>();
        while ((userAttributeSubpacket = userAttributeSubpacketInputStream.readPacket()) != null) {
            vector.addElement(userAttributeSubpacket);
        }
        this.subpackets = new UserAttributeSubpacket[vector.size()];
        for (int i = 0; i != this.subpackets.length; ++i) {
            this.subpackets[i] = (UserAttributeSubpacket)vector.elementAt(i);
        }
    }

    public UserAttributePacket(UserAttributeSubpacket[] userAttributeSubpacketArray) {
        this.subpackets = userAttributeSubpacketArray;
    }

    public UserAttributeSubpacket[] getSubpackets() {
        return this.subpackets;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i != this.subpackets.length; ++i) {
            this.subpackets[i].encode(byteArrayOutputStream);
        }
        bCPGOutputStream.writePacket(17, byteArrayOutputStream.toByteArray(), false);
    }
}

