/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.Signer;
import edu.illinois.ncsa.bouncycastle.crypto.io.SignerInputStream;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECDomainParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECPublicKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.tls.CertificateRequest;
import edu.illinois.ncsa.bouncycastle.crypto.tls.NamedCurve;
import edu.illinois.ncsa.bouncycastle.crypto.tls.SecurityParameters;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsClientContext;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsCredentials;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsFatalAlert;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsSigner;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsSignerCredentials;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsUtils;
import edu.illinois.ncsa.bouncycastle.math.ec.ECPoint;
import java.io.IOException;
import java.io.InputStream;

class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    TlsECDHEKeyExchange(TlsClientContext tlsClientContext, int n) {
        super(tlsClientContext, n);
    }

    public void skipServerKeyExchange() throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        Signer signer = this.initSigner(this.tlsSigner, securityParameters);
        SignerInputStream signerInputStream = new SignerInputStream(inputStream, signer);
        short s = TlsUtils.readUint8(signerInputStream);
        if (s != 3) {
            throw new TlsFatalAlert(40);
        }
        int n = TlsUtils.readUint16(signerInputStream);
        ECDomainParameters eCDomainParameters = NamedCurve.getECParameters(n);
        byte[] byArray = TlsUtils.readOpaque8(signerInputStream);
        byte[] byArray2 = TlsUtils.readOpaque16(inputStream);
        if (!signer.verifySignature(byArray2)) {
            throw new TlsFatalAlert(42);
        }
        ECPoint eCPoint = eCDomainParameters.getCurve().decodePoint(byArray);
        this.ecAgreeServerPublicKey = this.validateECPublicKey(new ECPublicKeyParameters(eCPoint, eCDomainParameters));
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] sArray = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < sArray.length; ++i) {
            switch (sArray[i]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    protected Signer initSigner(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

