/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.util.encoders.test;

import edu.illinois.ncsa.bouncycastle.util.encoders.Base64;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.util.Arrays;
import java.util.Random;

public class EncoderTest
extends SimpleTest {
    public static final boolean DEBUG = true;

    public static void main(String[] stringArray) {
        EncoderTest.runTest(new EncoderTest());
    }

    public String getName() {
        return "Encoder";
    }

    public void performTest() {
        this.testHex();
        this.testBase64();
        this.testBase64WithNL();
    }

    public void testBase64() {
        try {
            Random random = new Random();
            byte[] byArray = new byte[1024];
            random.nextBytes(byArray);
            byte[] byArray2 = new byte[2048];
            random.nextBytes(byArray2);
            byte[] byArray3 = new byte[4096];
            random.nextBytes(byArray3);
            byte[] byArray4 = new byte[8192];
            random.nextBytes(byArray4);
            byte[] byArray5 = Base64.encode(byArray);
            byte[] byArray6 = Base64.encode(byArray2);
            byte[] byArray7 = Base64.encode(byArray3);
            byte[] byArray8 = Base64.encode(byArray4);
            byte[] byArray9 = Base64.decode(byArray5);
            byte[] byArray10 = Base64.decode(byArray6);
            byte[] byArray11 = Base64.decode(byArray7);
            byte[] byArray12 = Base64.decode(byArray8);
            if (!Arrays.equals(byArray, byArray9)) {
                this.fail("Failed Base64 test");
            }
            if (!Arrays.equals(byArray2, byArray10)) {
                this.fail("Failed Base64 test");
            }
            if (!Arrays.equals(byArray3, byArray11)) {
                this.fail("Failed Base64 test");
            }
            if (!Arrays.equals(byArray4, byArray12)) {
                this.fail("Failed Base64 test");
            }
            byte[] byArray13 = new byte[1025];
            random.nextBytes(byArray13);
            byte[] byArray14 = new byte[2049];
            random.nextBytes(byArray14);
            byte[] byArray15 = new byte[4097];
            random.nextBytes(byArray15);
            byte[] byArray16 = new byte[8193];
            random.nextBytes(byArray16);
            byte[] byArray17 = Base64.encode(byArray13);
            byte[] byArray18 = Base64.encode(byArray14);
            byte[] byArray19 = Base64.encode(byArray15);
            byte[] byArray20 = Base64.encode(byArray16);
            byte[] byArray21 = Base64.decode(byArray17);
            byte[] byArray22 = Base64.decode(byArray18);
            byte[] byArray23 = Base64.decode(byArray19);
            byte[] byArray24 = Base64.decode(byArray20);
            if (!Arrays.equals(byArray13, byArray21)) {
                this.fail("Failed Base64 test");
            }
            if (!Arrays.equals(byArray14, byArray22)) {
                this.fail("Failed Base64 test");
            }
            if (!Arrays.equals(byArray15, byArray23)) {
                this.fail("Failed Base64 test");
            }
            if (!Arrays.equals(byArray16, byArray24)) {
                this.fail("Failed Base64 test");
            }
        }
        catch (Exception exception) {
            this.fail("Failed Base64 test");
        }
    }

    public void testBase64WithNL() {
        byte[] byArray = Base64.decode("SVNC\nQUQ=\n");
        if (byArray.length != 5) {
            this.fail("got length " + byArray.length + " when expecting 10");
        }
        if (!this.areEqual(byArray, Base64.decode("SVNCQUQ="))) {
            this.fail("decodings are not equal");
        }
    }

    public void testHex() {
        try {
            Random random = new Random();
            byte[] byArray = new byte[1024];
            random.nextBytes(byArray);
            byte[] byArray2 = new byte[2048];
            random.nextBytes(byArray2);
            byte[] byArray3 = new byte[4096];
            random.nextBytes(byArray3);
            byte[] byArray4 = new byte[8192];
            random.nextBytes(byArray4);
            byte[] byArray5 = Hex.encode(byArray);
            byte[] byArray6 = Hex.encode(byArray2);
            byte[] byArray7 = Hex.encode(byArray3);
            byte[] byArray8 = Hex.encode(byArray4);
            byte[] byArray9 = Hex.decode(byArray5);
            byte[] byArray10 = Hex.decode(byArray6);
            byte[] byArray11 = Hex.decode(byArray7);
            byte[] byArray12 = Hex.decode(byArray8);
            if (!Arrays.equals(byArray, byArray9)) {
                this.fail("Failed Hex test");
            }
            if (!Arrays.equals(byArray2, byArray10)) {
                this.fail("Failed Hex test");
            }
            if (!Arrays.equals(byArray3, byArray11)) {
                this.fail("Failed Hex test");
            }
            if (!Arrays.equals(byArray4, byArray12)) {
                this.fail("Failed Hex test");
            }
            byte[] byArray13 = new byte[1025];
            random.nextBytes(byArray13);
            byte[] byArray14 = new byte[2049];
            random.nextBytes(byArray14);
            byte[] byArray15 = new byte[4097];
            random.nextBytes(byArray15);
            byte[] byArray16 = new byte[8193];
            random.nextBytes(byArray16);
            byte[] byArray17 = Hex.encode(byArray13);
            byte[] byArray18 = Hex.encode(byArray14);
            byte[] byArray19 = Hex.encode(byArray15);
            byte[] byArray20 = Hex.encode(byArray16);
            byte[] byArray21 = Hex.decode(byArray17);
            byte[] byArray22 = Hex.decode(byArray18);
            byte[] byArray23 = Hex.decode(byArray19);
            byte[] byArray24 = Hex.decode(byArray20);
            if (!Arrays.equals(byArray13, byArray21)) {
                this.fail("Failed Hex test");
            }
            if (!Arrays.equals(byArray14, byArray22)) {
                this.fail("Failed Hex test");
            }
            if (!Arrays.equals(byArray15, byArray23)) {
                this.fail("Failed Hex test");
            }
            if (!Arrays.equals(byArray16, byArray24)) {
                this.fail("Failed Hex test");
            }
        }
        catch (Exception exception) {
            this.fail("Failed Hex test");
        }
    }
}

