/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.FileChannelProvider;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.IOSession;

public abstract class FileSession
extends IOSession {
    public static final String DEV_NULL_FILENAME = "/dev/null";
    public static final String DEV_ZERO_FILENAME = "/dev/zero";
    private static final Logger logger = Logger.getLogger(FileSession.class.getName());
    public final AtomicLong cProcessedBytes = new AtomicLong(0L);
    protected final boolean isLoop;
    protected final FDTSession fdtSession;
    protected final boolean isNull;
    protected final boolean isZero;
    protected final FileChannelProvider fileChannelProvider;
    protected volatile String fileName;
    protected volatile FileChannel fileChannel;
    protected volatile File file;
    protected volatile int partitionID;
    protected volatile long lastModified;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSession(UUID uid, FDTSession fdtSession, String fileName, boolean isLoop, FileChannelProvider fileChannelProvider) {
        super(uid, -1L);
        this.fdtSession = fdtSession;
        boolean bNull = false;
        boolean bZero = false;
        File iFile = null;
        this.fileChannelProvider = fileChannelProvider;
        try {
            this.isLoop = isLoop;
            if (fileName == null) {
                throw new NullPointerException("The fileName cannot be null");
            }
            iFile = new File(fileName);
            this.fileName = fileName;
            this.lastModified = iFile.lastModified();
            if (fileName.startsWith(DEV_NULL_FILENAME)) {
                iFile = new File(DEV_NULL_FILENAME);
                bNull = true;
                return;
            }
            if (fileName.startsWith(DEV_ZERO_FILENAME)) {
                iFile = new File(DEV_ZERO_FILENAME);
                bZero = true;
                return;
            }
        }
        finally {
            this.file = iFile;
            this.isNull = bNull;
            this.isZero = bZero;
        }
    }

    public abstract FileChannel getChannel() throws Exception;

    public int partitionID() {
        return this.partitionID;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public final boolean isNull() {
        return this.isNull;
    }

    public final boolean isZero() {
        return this.isZero;
    }

    public File getFile() {
        return this.file;
    }

    public final boolean isLoop() {
        return this.isLoop;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    protected void internalClose() {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel != null) {
            try {
                if (!this.isLoop) {
                    fileChannel.close();
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, " Got exception closing file " + this.file, t);
            }
        }
    }

    public String fileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) throws IOException {
        this.fileName = fileName;
        this.file = new File(fileName);
    }
}

