/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.disk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.Utils;
import lia.util.net.copy.FileBlock;
import lia.util.net.copy.disk.DiskWriterTask;
import lia.util.net.copy.disk.GenericDiskManager;
import lia.util.net.copy.monitoring.DiskWriterManagerMonitoringTask;

public class DiskWriterManager
extends GenericDiskManager {
    private static final transient Logger logger = Logger.getLogger(DiskWriterManager.class.getName());
    private static final Config config = Config.getInstance();
    private static int MAX_PARTITION_COUNT = Integer.getInteger("fdt.MAX_PARTITION_COUNT", 1000);
    private static int WRITER_QUEUE_MULTIPLY_FACTOR = Integer.getInteger("fdt.wQueueM", 20);
    private static DiskWriterManager _thisInstance;
    private static volatile boolean initialized;
    private final ExecutorService execService;
    protected Exception finishException = null;
    ConcurrentHashMap<Integer, List<DiskWriterTask>> diskWritersMap = new ConcurrentHashMap();
    ConcurrentHashMap<Integer, BlockingQueue<FileBlock>> diskQueuesMap = new ConcurrentHashMap();
    private int writersPerPartionCount = 1;

    private DiskWriterManager() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, " \n\n --------> DiskWriterManager is instantiating <--------------- \n\n");
        }
        MAX_PARTITION_COUNT = config.getMaxPartitionCount();
        this.writersPerPartionCount = config.getWritersCount();
        if (this.writersPerPartionCount < 0) {
            this.writersPerPartionCount = 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DiskWriterManager will use: " + this.writersPerPartionCount + " writers per partition");
        }
        this.execService = Utils.getStandardExecService("DiskWriterTask ", 1, MAX_PARTITION_COUNT * this.writersPerPartionCount, 5);
        ScheduledThreadPoolExecutor monitoringService = Utils.getMonitoringExecService();
        monitoringService.scheduleWithFixedDelay(new DiskWriterManagerMonitoringTask(this), 1L, 5L, TimeUnit.SECONDS);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, " \n\n --------> DiskWriterManager is instantiatied <--------------- \n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final DiskWriterManager getInstance() {
        if (initialized) return _thisInstance;
        Class<DiskWriterManager> clazz = DiskWriterManager.class;
        synchronized (DiskWriterManager.class) {
            if (initialized) return _thisInstance;
            _thisInstance = new DiskWriterManager();
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return _thisInstance;
        }
    }

    @Override
    protected void internalClose() {
        for (Integer parititonID : this.diskWritersMap.keySet()) {
            this.stopWritersForPartition(parititonID);
        }
    }

    public Map<Integer, List<DiskWriterTask>> getWritersMap() {
        return this.diskWritersMap;
    }

    synchronized void stopWritersForPartition(Integer partitionID) {
        Iterator<DiskWriterTask> iterator;
        List<DiskWriterTask> writersTasks = this.diskWritersMap.remove(partitionID);
        if (writersTasks != null && (iterator = writersTasks.iterator()).hasNext()) {
            DiskWriterTask dwt = iterator.next();
            if (dwt != null) {
                dwt.stopIt();
            }
            return;
        }
        this.diskQueuesMap.remove(partitionID);
        logger.log(Level.INFO, " All the writers for partitionID: " + partitionID + " were stopped!");
    }

    private synchronized boolean startWritersForPartition(int partitionID) {
        Integer iPart = partitionID;
        BlockingQueue<FileBlock> pQueue = this.diskQueuesMap.get(iPart);
        if (pQueue != null) {
            return false;
        }
        pQueue = new ArrayBlockingQueue<FileBlock>(WRITER_QUEUE_MULTIPLY_FACTOR * this.writersPerPartionCount);
        if (this.diskQueuesMap.putIfAbsent(iPart, pQueue) == null) {
            ArrayList<DiskWriterTask> diskWritersTasks = new ArrayList<DiskWriterTask>(this.writersPerPartionCount);
            for (int i = 0; i < this.writersPerPartionCount; ++i) {
                DiskWriterTask dwt = new DiskWriterTask(partitionID, i, pQueue);
                diskWritersTasks.add(dwt);
                this.execService.submit(dwt);
            }
            if (diskWritersTasks.size() <= 0) {
                logger.log(Level.SEVERE, "\n\n [ BUG ?] diskWritersTasks has size 0 in startWritersForPartition(" + partitionID + ")...\n\n");
                return false;
            }
            this.diskWritersMap.put(iPart, diskWritersTasks);
            return true;
        }
        return false;
    }

    public int getQueueSize(int partitionID) {
        BlockingQueue<FileBlock> pQueue = this.diskQueuesMap.get(partitionID);
        if (pQueue == null) {
            return -1;
        }
        return pQueue.size();
    }

    public boolean offerFileBlock(FileBlock fileBlock, int partitionID, long timeout, TimeUnit unit) throws InterruptedException {
        Integer iPart = partitionID;
        BlockingQueue<FileBlock> pQueue = this.diskQueuesMap.get(iPart);
        if (pQueue != null) {
            return pQueue.offer(fileBlock, timeout, unit);
        }
        this.startWritersForPartition(partitionID);
        pQueue = this.diskQueuesMap.get(iPart);
        if (pQueue != null) {
            return pQueue.offer(fileBlock, timeout, unit);
        }
        logger.log(Level.SEVERE, " [ FDT BUG ] Please notify developers! In DiskWriterManager pQueue is null after startWritersForPartition(" + partitionID + ") was called! Synch problems?");
        return false;
    }

    public void putFileBlock(FileBlock fileBlock, int partitionID) throws InterruptedException {
        Integer iPart = partitionID;
        BlockingQueue<FileBlock> pQueue = this.diskQueuesMap.get(iPart);
        if (pQueue != null) {
            pQueue.put(fileBlock);
            return;
        }
        this.startWritersForPartition(partitionID);
        pQueue = this.diskQueuesMap.get(iPart);
        if (pQueue != null) {
            pQueue.put(fileBlock);
        } else {
            logger.log(Level.SEVERE, " [ FDT BUG ] Please notify developers! In DiskWriterManager pQueue is null after startWritersForPartition(" + partitionID + ") was called! Synch problems?");
        }
    }

    static {
        initialized = false;
    }
}

