/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.LogManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import lia.util.net.copy.gui.AboutDialog;
import lia.util.net.copy.gui.ConnectDialog;
import lia.util.net.copy.gui.CustomLogHandler;
import lia.util.net.copy.gui.CustomPrintStream;
import lia.util.net.copy.gui.FDTPropsDialog;
import lia.util.net.copy.gui.FolderTable;
import lia.util.net.copy.gui.HelpDialog;
import lia.util.net.copy.gui.RemoteSessionManager;
import lia.util.net.copy.gui.StatusBar;
import lia.util.net.copy.gui.session.LocalSession;
import lia.util.net.copy.gui.session.RemoteSession;

public class FolderFrame
extends JFrame
implements ActionListener,
FocusListener {
    public FolderTable local;
    public FolderTable remote;
    public JMenu localMenu;
    public JMenu remoteMenu;
    public JMenu command;
    protected JMenuItem aboutItem;
    protected JMenuItem helpItem;
    protected JMenuItem connectItem;
    protected JMenuItem propsItem;
    protected StatusBar statusBar;
    ConnectDialog connect;
    RemoteSessionManager manager;
    ImageIcon prefsIcon;
    ImageIcon connIcon;
    ImageIcon leftIcon;
    ImageIcon rightIcon;
    ImageIcon mkdirIcon;
    ImageIcon removeIcon;
    ImageIcon indexIcon;
    private AboutDialog about;
    private HelpDialog help;
    private FDTPropsDialog props = new FDTPropsDialog(this);
    private JButton copyLeft;
    private JButton copyRight;
    private ImageIcon fdtIcon;

    public FolderFrame() {
        super("Fast Data Transfer");
        this.propsItem = new JMenuItem("Preferences");
        this.propsItem.setIcon(this.getPrefsIcon());
        this.propsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderFrame.this.props.setVisible(true);
                FolderFrame.this.props.toFront();
            }
        });
        JPanel panel = new JPanel();
        this.manager = new RemoteSessionManager(this.props, panel);
        this.connect = new ConnectDialog(this);
        this.manager.initiated = true;
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        JPanel pp = new JPanel();
        JScrollPane p1 = new JScrollPane(pp);
        this.statusBar = new StatusBar(p1);
        pp.setOpaque(true);
        pp.setBackground(Color.white);
        pp.setLayout(new BorderLayout());
        pp.add((Component)this.statusBar, "Center");
        p1.setOpaque(false);
        p1.setMinimumSize(new Dimension(5, 20));
        p1.setPreferredSize(new Dimension(5, 20));
        CustomPrintStream out = new CustomPrintStream(this.statusBar, System.out, "#000000");
        System.setOut(out);
        CustomPrintStream err = new CustomPrintStream(this.statusBar, System.err, "#ff0000");
        System.setErr(err);
        CustomLogHandler logHandler = new CustomLogHandler(this.statusBar);
        Enumeration<String> en = LogManager.getLogManager().getLoggerNames();
        while (en.hasMoreElements()) {
            String logName = en.nextElement();
            LogManager.getLogManager().getLogger(logName).addHandler(logHandler);
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        LocalSession localSession = new LocalSession();
        this.local = new FolderTable(localSession, this.manager, this.statusBar, this);
        JPanel left = this.createPanel(this.local);
        this.localMenu = new JMenu("Local");
        this.localMenu.add(this.local.visibleColumns);
        this.command = this.local.command;
        this.command.add((Component)this.propsItem, 1);
        RemoteSession session = new RemoteSession(this.manager);
        this.remote = new FolderTable(session, this.manager, this.statusBar, this);
        JPanel right = this.createPanel(this.remote);
        this.remoteMenu = new JMenu("Remote");
        this.remoteMenu.add(this.remote.visibleColumns);
        this.connectItem = new JMenuItem("Connect");
        this.connectItem.setIcon(this.getConnIcon());
        this.connectItem.addActionListener(this);
        this.remoteMenu.add(this.connectItem);
        this.manager.setCorrespondingPanel(this.local, this.remote);
        JPanel middle = new JPanel();
        middle.setLayout(new GridLayout(0, 1));
        middle.setOpaque(false);
        this.copyLeft = new JButton(this.getLeftIcon());
        this.copyLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderFrame.this.remote.copy();
                    }
                };
                FolderTable cfr_ignored_0 = FolderFrame.this.local;
                FolderTable.exec.execute(r);
            }
        });
        this.copyLeft.setFocusable(false);
        this.copyLeft.setMaximumSize(new Dimension(24, 24));
        this.copyLeft.setPreferredSize(new Dimension(24, 24));
        this.copyLeft.setToolTipText("Copy");
        this.copyLeft.setEnabled(false);
        middle.add(this.copyLeft);
        this.copyRight = new JButton(this.getRightIcon());
        this.copyRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderFrame.this.local.copy();
                    }
                };
                FolderTable cfr_ignored_0 = FolderFrame.this.local;
                FolderTable.exec.execute(r);
            }
        });
        this.copyRight.setFocusable(false);
        this.copyRight.setMaximumSize(new Dimension(24, 24));
        this.copyRight.setPreferredSize(new Dimension(24, 24));
        this.copyRight.setToolTipText("Copy");
        this.copyRight.setEnabled(false);
        middle.add(this.copyRight);
        middle.setMaximumSize(new Dimension(24, 72));
        middle.setPreferredSize(new Dimension(24, 72));
        JPanel pp1 = new JPanel();
        pp1.setOpaque(false);
        pp1.setLayout(new BoxLayout(pp1, 0));
        pp1.setMaximumSize(new Dimension(24, 72));
        pp1.setPreferredSize(new Dimension(24, 72));
        pp1.add(middle);
        p.add(left);
        p.add(pp1);
        p.add(right);
        this.manager.setSessions(localSession, session);
        JSplitPane splitPane = new JSplitPane(0, p, p1);
        splitPane.setOneTouchExpandable(true);
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(1.0);
        panel.add((Component)splitPane, "Center");
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)dim.getWidth(), (int)dim.getHeight() - 30);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        JMenuBar menu = new JMenuBar();
        menu.add(this.localMenu);
        menu.add(this.command);
        menu.add(this.remoteMenu);
        this.setJMenuBar(menu);
        this.setIconImage(this.getFDTIcon().getImage());
        this.about = new AboutDialog(this);
        JMenu h = new JMenu("Help");
        this.aboutItem = new JMenuItem("About");
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderFrame.this.about.setVisible(true);
            }
        });
        h.add(this.aboutItem);
        this.help = new HelpDialog(this);
        this.helpItem = new JMenuItem("Key mappings");
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderFrame.this.help.setVisible(true);
            }
        });
        h.add(this.helpItem);
        menu.add(h);
        this.local.getTable().requestFocusInWindow();
    }

    public static void main(String[] args) {
        FolderFrame panel = new FolderFrame();
        panel.setVisible(true);
        panel.toFront();
    }

    private Icon getPrefsIcon() {
        if (this.prefsIcon != null) {
            return this.prefsIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/preferences.png");
            this.prefsIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.prefsIcon;
    }

    private Icon getConnIcon() {
        if (this.connIcon != null) {
            return this.connIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/connect.gif");
            this.connIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.connIcon;
    }

    private final JPanel createPanel(FolderTable table) {
        JPanel left = new JPanel();
        left.setOpaque(false);
        left.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        p.add(table.roots);
        p.add(Box.createHorizontalStrut(5));
        p.add(table.refreshDir);
        p.add(Box.createHorizontalStrut(5));
        p.add(table.parentDir);
        p.add(Box.createHorizontalStrut(5));
        p.add(table.rootDir);
        p.add(Box.createHorizontalStrut(5));
        p.add(table.homeDir);
        p.add(Box.createHorizontalStrut(5));
        p.add(table.openDir);
        p.add(Box.createHorizontalStrut(5));
        p.add(table.separator);
        p.add(Box.createHorizontalStrut(5));
        p.add(table.mkdir);
        p.add(Box.createHorizontalStrut(5));
        p.add(table.remove);
        p.add(Box.createHorizontalStrut(5));
        p.add(table.freeSpace);
        p.add(Box.createHorizontalGlue());
        left.add((Component)p, "North");
        left.add((Component)table, "Center");
        left.setBorder(BorderFactory.createLoweredBevelBorder());
        return left;
    }

    private ImageIcon getFDTIcon() {
        if (this.fdtIcon != null) {
            return this.fdtIcon;
        }
        try {
            URL url = this.getClass().getResource("icons/fdt.png");
            this.fdtIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.fdtIcon;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.connect.setVisible(true);
        this.connect.toFront();
        if (this.connect.bDialogOK) {
            this.manager.initiated = false;
            int port = 54321;
            try {
                port = Integer.valueOf(this.connect.sPort);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.manager.connect(this.connect.sHost, this.connect.sUser, port);
        } else {
            this.manager.initiated = true;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.local.getTable().hasFocus()) {
            this.local.showSelection();
            this.remote.hideSelection();
            this.copyRight.setEnabled(true);
            this.copyLeft.setEnabled(false);
            this.local.scroll.getViewport().setBackground(FolderTable.cm);
            this.remote.scroll.getViewport().setBackground(FolderTable.cg);
        } else if (this.remote.getTable().hasFocus()) {
            this.remote.showSelection();
            this.local.hideSelection();
            this.copyRight.setEnabled(false);
            this.copyLeft.setEnabled(true);
            this.local.scroll.getViewport().setBackground(FolderTable.cg);
            this.remote.scroll.getViewport().setBackground(FolderTable.cm);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.copyLeft.setEnabled(false);
        this.copyRight.setEnabled(false);
    }

    private Icon getLeftIcon() {
        if (this.leftIcon != null) {
            return this.leftIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/left.png");
            this.leftIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.leftIcon;
    }

    private Icon getRightIcon() {
        if (this.rightIcon != null) {
            return this.rightIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/right.png");
            this.rightIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.rightIcon;
    }

    private Icon getMkDirIcon() {
        if (this.mkdirIcon != null) {
            return this.mkdirIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/mkdir.png");
            this.mkdirIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mkdirIcon;
    }

    private Icon getRemoveIcon() {
        if (this.removeIcon != null) {
            return this.removeIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/delete.png");
            this.removeIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.removeIcon;
    }

    private Icon getIndexIcon() {
        if (this.indexIcon != null) {
            return this.indexIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/index.png");
            this.indexIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.indexIcon;
    }
}

