/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import lia.util.net.copy.gui.ProgressBarUI;
import lia.util.net.copy.gui.RemoteSessionManager;

public class TransferMonitor
implements Runnable {
    private static final Object lock = new Object();
    private static final NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private final RemoteSessionManager manager;
    private final TransferMonitor _instance;
    private ProgressMonitor progressMonitor;
    private boolean push;
    private boolean toRun = false;
    private boolean workInProgress = false;

    public TransferMonitor(JPanel ft, boolean push, RemoteSessionManager manager) {
        this.push = push;
        this.manager = manager;
        this.progressMonitor = new ProgressMonitor(ft, "Initializing...", 0, 100);
        ft.setEnabled(true);
        UIManager.put("ProgressBar.foreground", new Color(8, 32, 128));
        this._instance = this;
        new Thread(this).start();
    }

    public static void main(String[] args) {
        ProgressMonitor m = new ProgressMonitor(new JPanel(), "Init", 0, 100);
        for (int i = 0; i < 100; ++i) {
            m.setProgress(i);
            m.setNote("<html>Transfer is " + nf.format(i) + "% complete<br>Transfer rate is " + i + "</html>");
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void restart(JPanel ft, boolean push) {
        this.push = push;
        this.progressMonitor.setProgress(0);
        this.progressMonitor.setNote("Initializing...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.progressMonitor.setVisible(true);
        Object object = lock;
        synchronized (object) {
            this.toRun = true;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finished() {
        Object object = lock;
        synchronized (object) {
            return !this.toRun && !this.workInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("[FDT TransferMonitorThread]");
        while (true) {
            Object object = lock;
            synchronized (object) {
                while (!this.toRun) {
                    try {
                        lock.wait();
                    }
                    catch (Exception exception) {}
                }
                this.toRun = false;
                this.workInProgress = true;
            }
            while (true) {
                if (this.manager == null) {
                    this.progressMonitor.close();
                    break;
                }
                if (this.progressMonitor.isCanceled()) {
                    System.out.println("cancelled");
                    this.progressMonitor.close();
                    this.manager.stopTransfer();
                    break;
                }
                double progress = this.manager.getTransferPercent();
                if (Double.isNaN(progress) || Double.isInfinite(progress)) {
                    this.progressMonitor.close();
                    this.manager.end();
                    break;
                }
                double val = Math.min(100.0, progress);
                if (val >= 100.0) {
                    this.progressMonitor.close();
                    if (this.push) {
                        if (this.manager != null && this.manager.getRemoteTable() != null) {
                            this.manager.getRemoteTable().setConnected(true);
                        }
                        this.manager.getLocalTable().getTable().requestFocusInWindow();
                    } else {
                        if (this.manager != null && this.manager.getLocalTable() != null) {
                            this.manager.getLocalTable().setConnected(true);
                        }
                        this.manager.getRemoteTable().getTable().requestFocusInWindow();
                    }
                    this.manager.end();
                    break;
                }
                if (!Double.isInfinite(val) && !Double.isNaN(val)) {
                    this.progressMonitor.setProgress((int)val);
                    this.progressMonitor.setNote("<html>Transfer is " + nf.format(val) + "% complete<br>Transfer rate is " + this.manager.getTransferSpeed() + "</html>");
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
            object = lock;
            synchronized (object) {
                this.workInProgress = false;
            }
        }
    }

    static {
        nf.setMaximumFractionDigits(2);
    }

    public static class ProgressMonitor
    extends JDialog {
        private JProgressBar progress;
        private JLabel label;
        private JButton cancel;
        private boolean isCancelled = false;

        public ProgressMonitor(JPanel component, String text, int min, int max) {
            JDialog.setDefaultLookAndFeelDecorated(true);
            this.setLocation((int)component.getLocationOnScreen().getX() + component.getWidth() / 2 - 160, (int)component.getLocationOnScreen().getY() + component.getHeight() / 2 - 62);
            this.setTitle("Copying");
            this.setDefaultCloseOperation(0);
            this.setAlwaysOnTop(true);
            ProgressMonitor.setDefaultLookAndFeelDecorated(true);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            JPanel p1 = new JPanel();
            p1.setLayout(new BorderLayout());
            this.label = new JLabel(text);
            p1.add((Component)this.label, "Center");
            this.getContentPane().add(p1);
            JPanel p2 = new JPanel();
            p2.setLayout(new BorderLayout());
            this.progress = new JProgressBar(min, max);
            this.progress.setUI(new ProgressBarUI());
            this.progress.setStringPainted(false);
            p2.add((Component)this.progress, "Center");
            this.getContentPane().add(p2);
            JPanel p3 = new JPanel();
            p3.setLayout(new BoxLayout(p3, 0));
            this.cancel = new JButton("Cancel");
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    isCancelled = true;
                    this.setVisible(false);
                }
            });
            p3.add(this.cancel);
            this.getContentPane().add(Box.createVerticalStrut(3));
            this.getContentPane().add(p3);
            this.getContentPane().add(Box.createVerticalStrut(3));
            this.setSize(320, 125);
            this.setResizable(false);
        }

        public void close() {
            this.isCancelled = false;
            this.setVisible(false);
        }

        public boolean isCanceled() {
            return this.isCancelled;
        }

        public void setProgress(int progress) {
            this.progress.setValue(progress);
            this.progress.repaint();
        }

        public void setNote(String note) {
            this.label.setText(note);
            this.label.repaint();
        }
    }
}

