/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import lia.util.net.copy.monitoring.lisa.MacHostPropertiesMonitor;
import lia.util.net.copy.monitoring.lisa.ProcReader;

public class HostPropertiesMonitor {
    static final String osName = System.getProperty("os.name");
    ProcReader reader = null;
    MacHostPropertiesMonitor macHostMonitor = null;
    String macAddress;
    HashMap<String, Double> cpuvm;
    HashMap<String, Double> mem;
    HashMap<String, Double> disk;
    int processes;
    HashMap<String, Double> load;
    HashMap<String, Double> net;

    public HostPropertiesMonitor(Logger logger) {
        if (osName.indexOf("Linux") != -1) {
            this.reader = new ProcReader(logger);
        } else if (osName.indexOf("Mac") != -1) {
            this.macHostMonitor = new MacHostPropertiesMonitor(logger);
        }
    }

    public static void saveSystemLibrary(Class baseClass) {
        try {
            URL url = baseClass.getResource("system.dll");
            File file = new File("system.dll");
            if (!file.exists()) {
                int n;
                byte[] buffer = new byte[1024];
                URLConnection con = url.openConnection();
                InputStream in = con.getInputStream();
                FileOutputStream out = new FileOutputStream(file);
                while ((n = in.read(buffer, 0, buffer.length)) != -1) {
                    out.write(buffer, 0, n);
                }
                in.close();
                out.close();
            }
            System.load(file.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public native String getMacAddresses();

    public String getMacAddressesCall() {
        if (osName.indexOf("Linux") != -1) {
            return this.macAddress;
        }
        if (osName.indexOf("Mac") != -1) {
            return this.macHostMonitor.getMacAddresses();
        }
        return this.getMacAddresses();
    }

    public native void update();

    public void updateCall() {
        if (osName.indexOf("Linux") != -1) {
            try {
                this.macAddress = this.reader.getMACAddress();
                this.cpuvm = this.reader.getCPUVM();
                this.mem = this.reader.getMEM();
                this.disk = this.reader.getDISK();
                this.processes = this.reader.getProcesses();
                this.load = this.reader.getLOAD();
                this.net = this.reader.getNet();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (osName.indexOf("Mac") != -1) {
            this.macHostMonitor.update();
            return;
        }
        this.update();
    }

    private final double get(String val) {
        try {
            return Double.parseDouble(val);
        }
        catch (Throwable throwable) {
            return -1.0;
        }
    }

    public native String getCpuUsage();

    public double getCpuUsageCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("CPU_Usage");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getCpuUsage());
        }
        return this.get(this.getCpuUsage());
    }

    public native String getCpuUSR();

    public double getCpuUSRCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("CPU_usr");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getCpuUSR());
        }
        return this.get(this.getCpuUSR());
    }

    public native String getCpuSYS();

    public double getCpuSYSCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("CPU_sys");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getCpuSYS());
        }
        return this.get(this.getCpuSYS());
    }

    public native String getCpuNICE();

    public double getCpuNICECall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("CPU_nice");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getCpuNICE());
        }
        return this.get(this.getCpuNICE());
    }

    public native String getCpuIDLE();

    public double getCpuIDLECall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("CPU_idle");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getCpuIDLE());
        }
        return this.get(this.getCpuIDLE());
    }

    public double getCPUIoWaitCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("CPU_iowait");
        }
        return -1.0;
    }

    public double getCPUIntCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("CPU_int");
        }
        return -1.0;
    }

    public double getCPUSoftIntCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("CPU_softint");
        }
        return -1.0;
    }

    public double getCPUStealCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("CPU_steal");
        }
        return -1.0;
    }

    public native String getPagesIn();

    public double getPagesInCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("Page_in");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getPagesIn());
        }
        return this.get(this.getPagesIn());
    }

    public native String getPagesOut();

    public double getPagesOutCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("Page_out");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getPagesOut());
        }
        return this.get(this.getPagesOut());
    }

    public double getSwapInCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("Swap_in");
        }
        return -1.0;
    }

    public double getSwapOutCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.cpuvm == null) {
                return -1.0;
            }
            return this.cpuvm.get("Swap_out");
        }
        return -1.0;
    }

    public native String getMemUsage();

    public double getMemUsageCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.mem == null) {
                return -1.0;
            }
            return this.mem.get("MemUsage");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getMemUsage());
        }
        return this.get(this.getMemUsage());
    }

    public native String getMemUsed();

    public double getMemUsedCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.mem == null) {
                return -1.0;
            }
            return this.mem.get("MemUsed");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getMemUsed());
        }
        return this.get(this.getMemUsed());
    }

    public native String getMemFree();

    public double getMemFreeCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.mem == null) {
                return -1.0;
            }
            return this.mem.get("MemFree");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getMemFree());
        }
        return this.get(this.getMemFree());
    }

    public native String getDiskIO();

    public double getDiskIOCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.disk == null) {
                return -1.0;
            }
            return this.disk.get("DiskIO");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getDiskIO());
        }
        return this.get(this.getDiskIO());
    }

    public native String getDiskTotal();

    public double getDiskTotalCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.disk == null) {
                return -1.0;
            }
            return this.disk.get("DiskTotal");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getDiskTotal());
        }
        return this.get(this.getDiskTotal());
    }

    public native String getDiskUsed();

    public double getDiskUsedCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.disk == null) {
                return -1.0;
            }
            return this.disk.get("DiskUsed");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getDiskUsed());
        }
        return this.get(this.getDiskUsed());
    }

    public native String getDiskFree();

    public double getDiskFreeCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.disk == null) {
                return -1.0;
            }
            return this.disk.get("DiskFree");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getDiskFree());
        }
        return this.get(this.getDiskFree());
    }

    public native String getNoProcesses();

    public int getNoProcessesCall() {
        if (osName.indexOf("Linux") != -1) {
            return this.processes;
        }
        if (osName.indexOf("Mac") != -1) {
            return (int)this.get(this.macHostMonitor.getNoProcesses());
        }
        return (int)this.get(this.getNoProcesses());
    }

    public native String getLoad1();

    public double getLoad1Call() {
        if (osName.indexOf("Linux") != -1) {
            if (this.load == null) {
                return -1.0;
            }
            return this.load.get("Load1");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getLoad1());
        }
        return this.get(this.getLoad1());
    }

    public native String getLoad5();

    public double getLoad5Call() {
        if (osName.indexOf("Linux") != -1) {
            if (this.load == null) {
                return -1.0;
            }
            return this.load.get("Load5");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getLoad5());
        }
        return this.get(this.getLoad5());
    }

    public native String getLoad15();

    public double getLoad15Call() {
        if (osName.indexOf("Linux") != -1) {
            if (this.load == null) {
                return -1.0;
            }
            return this.load.get("Load15");
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getLoad15());
        }
        return this.get(this.getLoad15());
    }

    public native String[] getNetInterfaces();

    public String[] getNetInterfacesCall() {
        if (osName.indexOf("Linux") != -1) {
            if (this.net == null) {
                return null;
            }
            String[] ret = new String[this.net.size() / 2];
            int i = 0;
            Iterator<String> it = this.net.keySet().iterator();
            while (it.hasNext() && i < ret.length) {
                String key = it.next();
                if (!key.startsWith("In_")) continue;
                ret[i] = key.substring(3);
                ++i;
            }
            while (i < ret.length) {
                ret[i++] = null;
            }
            return ret;
        }
        if (osName.indexOf("Mac") != -1) {
            return this.macHostMonitor.getNetInterfaces();
        }
        return this.getNetInterfaces();
    }

    public native String getNetIn(String var1);

    public double getNetInCall(String ifName) {
        if (osName.indexOf("Linux") != -1) {
            if (this.net == null || !this.net.containsKey("In_" + ifName)) {
                return -1.0;
            }
            return this.net.get("In_" + ifName);
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getNetIn(ifName));
        }
        return this.get(this.getNetIn(ifName));
    }

    public native String getNetOut(String var1);

    public double getNetOutCall(String ifName) {
        if (osName.indexOf("Linux") != -1) {
            if (this.net == null || !this.net.containsKey("Out_" + ifName)) {
                return -1.0;
            }
            return this.net.get("Out_" + ifName);
        }
        if (osName.indexOf("Mac") != -1) {
            return this.get(this.macHostMonitor.getNetOut(ifName));
        }
        return this.get(this.getNetOut(ifName));
    }

    static {
        if (osName.indexOf("Win") >= 0) {
            HostPropertiesMonitor.saveSystemLibrary(HostPropertiesMonitor.class);
        }
    }
}

