/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa.net.netstat;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lia.util.net.copy.monitoring.lisa.net.PatternUtil;
import lia.util.net.copy.monitoring.lisa.net.netstat.Connection;

public class Netstat {
    protected final PrintStream out;
    protected final HashMap<String, String> pids = new HashMap();
    final String[] states = new String[]{"ESTBLSH", "SYNSENT", "SYNRECV", "FWAIT1", "FWAIT2", "TMEWAIT", "CLOSED", "CLSWAIT", "LASTACK", "LISTEN", "CLOSING", "UNKNOWN"};
    private final String netPattern = "\\d+:\\s+([\\dA-F]+):([\\dA-F]+)\\s+([\\dA-F]+):([\\dA-F]+)\\s+([\\dA-F]+)\\s+[\\dA-F]+:[\\dA-F]+\\s+[\\dA-F]+:[\\dA-F]+\\s+[\\dA-F]+\\s+([\\d]+)\\s+[\\d]+\\s+([\\d]+)";

    public Netstat(PrintStream out) {
        this.out = out;
    }

    public static void main(String[] args) {
        System.out.println("Start");
        Netstat n = new Netstat(System.out);
        List<Connection> c = n.getConnections();
        for (Connection conn : c) {
            System.out.println(conn);
        }
        System.out.println("end");
    }

    private final String getAddress(String hexa) {
        try {
            long v = Long.parseLong(hexa, 16);
            long adr = v >>> 24 | v << 24 | v << 8 & 0xFF0000L | v >> 8 & 0xFF00L;
            return (adr >> 24 & 0xFFL) + "." + (adr >> 16 & 0xFFL) + "." + (adr >> 8 & 0xFFL) + "." + (adr & 0xFFL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "0.0.0.0";
        }
    }

    private final int getInt16(String hexa) {
        try {
            return Integer.parseInt(hexa, 16);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    private final String getStatPath() {
        String path = System.getProperty("net.stat.path", "/usr/bin/");
        if (!(path = path.trim()).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    private final String getPUID(String uid) {
        if (this.pids.containsKey(uid)) {
            return this.pids.get(uid);
        }
        String pat = "([\\S&&[^:]]+):[\\S&&[^:]]+:" + uid + ":";
        Pattern pattern = PatternUtil.getPattern("uid_" + uid, pat);
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader("/etc/passwd"));
            while ((line = in.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                String puid = matcher.group(1);
                this.pids.put(uid, puid);
                return puid;
            }
            in.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.pids.put(uid, "UNKNOWN");
        return "UNKNOWN";
    }

    private final String getPName(int pid) {
        String pat = "Name:\\s*(\\S+)";
        Pattern pattern = PatternUtil.getPattern("pname", "Name:\\s*(\\S+)");
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader("/proc/" + pid + "/status"));
            while ((line = in.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                return matcher.group(1);
            }
            in.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "UNKNOWN";
    }

    public List<Connection> getConnections() {
        String inode;
        String uid;
        String statusHexa;
        String remotePortHexa;
        String remoteAddressHexa;
        String localPortHexa;
        Connection c;
        Matcher matcher;
        Pattern pattern;
        String line;
        BufferedReader in2;
        ArrayList<Connection> net = new ArrayList<Connection>();
        try {
            in2 = new BufferedReader(new FileReader("/proc/net/tcp"));
            while ((line = in2.readLine()) != null) {
                pattern = PatternUtil.getPattern("/proc/net/tcp", "\\d+:\\s+([\\dA-F]+):([\\dA-F]+)\\s+([\\dA-F]+):([\\dA-F]+)\\s+([\\dA-F]+)\\s+[\\dA-F]+:[\\dA-F]+\\s+[\\dA-F]+:[\\dA-F]+\\s+[\\dA-F]+\\s+([\\d]+)\\s+[\\d]+\\s+([\\d]+)");
                matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                c = new Connection();
                c.setProtocol((byte)0);
                net.add(c);
                localPortHexa = matcher.group(2);
                remoteAddressHexa = matcher.group(3);
                remotePortHexa = matcher.group(4);
                statusHexa = matcher.group(5);
                uid = matcher.group(6);
                inode = matcher.group(7);
                c.setLocalPort(this.getInt16(localPortHexa));
                c.setRemoteAddress(this.getAddress(remoteAddressHexa));
                c.setRemotePort(this.getInt16(remotePortHexa));
                try {
                    c.setStatus(this.states[Integer.parseInt(statusHexa, 16) - 1]);
                }
                catch (Exception ex) {
                    c.setStatus(this.states[11]);
                }
                c.setPID(-1);
                c.setPName("UNKNOWN");
                c.setPOwner(this.getPUID(uid));
            }
            in2.close();
        }
        catch (Throwable in2) {
            // empty catch block
        }
        try {
            in2 = new BufferedReader(new FileReader("/proc/net/udp"));
            while ((line = in2.readLine()) != null) {
                pattern = PatternUtil.getPattern("/proc/net/tcp", "\\d+:\\s+([\\dA-F]+):([\\dA-F]+)\\s+([\\dA-F]+):([\\dA-F]+)\\s+([\\dA-F]+)\\s+[\\dA-F]+:[\\dA-F]+\\s+[\\dA-F]+:[\\dA-F]+\\s+[\\dA-F]+\\s+([\\d]+)\\s+[\\d]+\\s+([\\d]+)");
                matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                c = new Connection();
                c.setProtocol((byte)1);
                net.add(c);
                localPortHexa = matcher.group(2);
                remoteAddressHexa = matcher.group(3);
                remotePortHexa = matcher.group(4);
                statusHexa = matcher.group(5);
                uid = matcher.group(6);
                inode = matcher.group(7);
                c.setLocalPort(this.getInt16(localPortHexa));
                c.setRemoteAddress(this.getAddress(remoteAddressHexa));
                c.setRemotePort(this.getInt16(remotePortHexa));
                try {
                    c.setStatus(this.states[Integer.parseInt(statusHexa, 16) - 1]);
                }
                catch (Exception ex) {
                    c.setStatus(this.states[11]);
                }
                c.setPID(-1);
                c.setPName("UNKNOWN");
                c.setPOwner(this.getPUID(uid));
            }
            in2.close();
        }
        catch (Throwable in3) {
            // empty catch block
        }
        try {
            in2 = new BufferedReader(new FileReader("/proc/net/raw"));
            while ((line = in2.readLine()) != null) {
                pattern = PatternUtil.getPattern("/proc/net/tcp", "\\d+:\\s+([\\dA-F]+):([\\dA-F]+)\\s+([\\dA-F]+):([\\dA-F]+)\\s+([\\dA-F]+)\\s+[\\dA-F]+:[\\dA-F]+\\s+[\\dA-F]+:[\\dA-F]+\\s+[\\dA-F]+\\s+([\\d]+)\\s+[\\d]+\\s+([\\d]+)");
                matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                c = new Connection();
                c.setProtocol((byte)2);
                net.add(c);
                localPortHexa = matcher.group(2);
                remoteAddressHexa = matcher.group(3);
                remotePortHexa = matcher.group(4);
                statusHexa = matcher.group(5);
                uid = matcher.group(6);
                inode = matcher.group(7);
                c.setLocalPort(this.getInt16(localPortHexa));
                c.setRemoteAddress(this.getAddress(remoteAddressHexa));
                c.setRemotePort(this.getInt16(remotePortHexa));
                try {
                    c.setStatus(this.states[Integer.parseInt(statusHexa, 16) - 1]);
                }
                catch (Exception ex) {
                    c.setStatus(this.states[11]);
                }
                c.setPID(-1);
                c.setPName("UNKNOWN");
                c.setPOwner(this.getPUID(uid));
            }
            in2.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return net;
    }
}

