/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa.xdr;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.copy.monitoring.lisa.xdr.XDRInputStream;
import lia.util.net.copy.monitoring.lisa.xdr.XDRMessage;
import lia.util.net.copy.monitoring.lisa.xdr.XDROutputStream;

public abstract class XDRGenericComm
implements Runnable {
    private static final transient Logger logger = Logger.getLogger(XDRGenericComm.class.getName());
    private static long keys;
    private static Object keyLock;
    protected XDRInputStream xdris;
    protected XDROutputStream xdros;
    protected boolean closed;
    String myName;
    private String key;

    public XDRGenericComm(String myName, XDROutputStream xdros, XDRInputStream xdris, boolean closed) {
        this.setMyName(myName);
        this.xdris = xdris;
        this.xdros = xdros;
        this.closed = closed;
        this.key = null;
    }

    public XDRGenericComm(String myName, XDROutputStream xdros, XDRInputStream xdris) {
        this(myName, xdros, xdris, false);
    }

    public XDRGenericComm(String myName) {
        this(myName, null, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String nextKey() {
        Object object = keyLock;
        synchronized (object) {
            return "" + keys++;
        }
    }

    protected abstract void initSession() throws Exception;

    protected abstract void xdrSession() throws Exception;

    protected abstract void notifyXDRCommClosed();

    @Override
    public void run() {
        try {
            this.initSession();
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Session [" + System.currentTimeMillis() + " ] " + this.myName + " K: [" + this.getKey() + "] cannot be initialized..closing", e);
            }
            this.notifyXDRCommClosed();
            this.close();
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, " [ " + System.currentTimeMillis() + " ] " + this.getMyName() + " enter main-loop. ");
        }
        try {
            this.xdrSession();
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, " [ " + System.currentTimeMillis() + " ] " + this.getMyName() + " is broken. Closing it.. ");
            }
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            XDRMessage msg = XDRMessage.getErrorMessage(sw.getBuffer().toString());
            try {
                this.write(msg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.notifyXDRCommClosed();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, " [ " + System.currentTimeMillis() + " ] " + this.myName + " K: [" + this.getKey() + "] exits now .... \n\n");
        }
        this.close();
    }

    public XDRMessage read() throws IOException {
        try {
            XDRMessage msg = new XDRMessage();
            msg.xdrMessageSize = this.xdris.readInt();
            this.xdris.pad();
            msg.status = this.xdris.readInt();
            this.xdris.pad();
            msg.payload = this.xdris.readString();
            this.xdris.pad();
            return msg;
        }
        catch (EOFException eofe) {
            logger.log(Level.INFO, " [ " + System.currentTimeMillis() + " ] " + this.getMyName() + ": Connection closed by remote host");
            throw new IOException(" [ " + System.currentTimeMillis() + " ] " + this.getMyName() + ": Connection closed by remote host");
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "XDR Read Error: Cause:", t);
            } else if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "XDR Read Error. Cause:[" + t.getMessage() + "]");
            }
            throw new IOException("XDR Read Error: [" + t.getMessage() + "]");
        }
    }

    public synchronized void write(XDRMessage msg) throws IOException {
        try {
            msg.xdrMessageSize = this.getXDRSize(msg);
            this.xdros.writeInt(msg.xdrMessageSize);
            this.xdros.pad();
            this.xdros.writeInt(msg.status);
            this.xdros.pad();
            this.xdros.writeString(msg.payload);
            this.xdros.pad();
            this.xdros.flush();
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "XDR Write Error", t);
            } else if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "XDR Write Error. Cause:[" + t.getMessage() + "]");
            }
            throw new IOException("XDR Write error: [" + t.getMessage() + "]");
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                if (this.xdris != null) {
                    this.xdris.close();
                }
                if (this.xdros != null) {
                    this.xdros.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getKey() {
        if (this.key == null) {
            this.key = XDRGenericComm.nextKey();
        }
        return this.key;
    }

    private int getXDRSize(String data) {
        int size = 0;
        if (data != null && data.length() != 0 && (size = data.length() + 4) % 4 != 0) {
            size += 4 - size % 4;
        }
        return size;
    }

    private int getXDRSize(XDRMessage msg) {
        int size = 8;
        return size += this.getXDRSize(msg.payload);
    }

    public String getMyName() {
        return this.myName;
    }

    public void setMyName(String myName) {
        this.myName = myName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = keyLock = new Object();
        synchronized (object) {
            keys = 0L;
        }
    }
}

