/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.jiperf;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.jiperf.ByteBufferPool;
import lia.util.net.jiperf.JIperf;
import lia.util.net.jiperf.control.ControlStream;

public class JIperfClient {
    private static final transient Logger logger = Logger.getLogger(JIperfClient.class.getName());
    Selector sel;
    int serverPort;
    int sockNum;
    String serverHost;
    Executor executor;
    ByteBufferPool buffPool;
    ArrayBlockingQueue<ByteBuffer> queueToSend;
    private ControlStream control;

    public JIperfClient(HashMap<String, String> config) throws Exception {
        this.serverPort = Integer.parseInt(config.get("-p"));
        this.serverHost = config.get("-c");
        try {
            this.sockNum = Integer.parseInt(config.get("-P"));
        }
        catch (Throwable t) {
            this.sockNum = 1;
        }
        if (config.containsKey("-ssh")) {
            String user = config.containsKey("-u") ? config.get("-u") : System.getProperty("user.name");
            String command = config.containsKey("-E") ? config.get("-E") : "java -XX:MaxDirectMemorySize=512m -cp ~/JIPERF/TEST_JAVA_IO_PERF/JPERF_NIO/bin lia.util.net.jiperf.JIperf -ssh -s";
            System.out.println(" [Client] Using SSH mode: connecting to " + user + "@" + this.serverHost + " start command:" + command);
            try {
                this.control = new ControlStream();
                this.control.startServer(this.serverHost, user, command);
                this.control.waitAck();
                String myIP = null;
                if (config.containsKey("-F")) {
                    myIP = config.get("-F");
                }
                this.control.sendInitCommands(myIP, this.serverPort, this.sockNum, -1);
                this.control.waitAck();
            }
            catch (Exception e) {
                System.out.println(" [Client] ERROR: " + e);
                System.exit(1);
            }
        }
        this.queueToSend = new ArrayBlockingQueue(11);
        this.buffPool = ByteBufferPool.getInstance();
        if (this.sockNum < 1) {
            this.sockNum = 1;
        }
        this.init();
        this.executor = JIperf.getExecutor();
    }

    public void init() throws Exception {
        this.sel = Selector.open();
        InetSocketAddress addr = new InetSocketAddress(this.serverHost, this.serverPort);
        for (int i = 0; i < this.sockNum; ++i) {
            SocketChannel sc = SocketChannel.open();
            sc.configureBlocking(false);
            System.out.println("initiating connection");
            sc.connect(addr);
            Thread t = new Thread(new FillingTask());
            t.setDaemon(true);
            t.start();
            while (!sc.finishConnect()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            System.out.println("connection established");
            sc.register(this.sel, 4);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void flood() throws Exception {
        block0: while (true) {
            if (this.sel.select() > 0) {
                continue;
            }
            it = this.sel.selectedKeys().iterator();
            while (true) {
                if (it.hasNext()) ** break;
                continue block0;
                sk = it.next();
                if (sk.isWritable()) {
                    sk.interestOps(sk.interestOps() & -5);
                    this.executor.execute(new WriterTask(sk));
                }
                it.remove();
            }
            break;
        }
    }

    class WriterTask
    implements Runnable {
        SelectionKey sk;
        ByteBuffer buff;

        WriterTask(SelectionKey sk) {
            this.sk = sk;
        }

        private void writeData() throws Exception {
            this.buff = JIperfClient.this.queueToSend.take();
            SocketChannel sc = (SocketChannel)this.sk.channel();
            int count = -1;
            while ((count = sc.write(this.buff)) > 0) {
            }
            if (count < 0) {
                sc.close();
            } else {
                this.sk.interestOps(this.sk.interestOps() | 4);
            }
            JIperfClient.this.sel.wakeup();
        }

        @Override
        public void run() {
            if (this.sk == null) {
                return;
            }
            try {
                this.writeData();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                JIperfClient.this.buffPool.put(this.buff);
            }
        }
    }

    class FillingTask
    implements Runnable {
        FileChannel readChannel;

        FillingTask() throws Exception {
            File dev_zero = new File("/dev/zero");
            this.readChannel = new FileInputStream(dev_zero).getChannel();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ByteBuffer buff = JIperfClient.this.buffPool.get();
                        this.readChannel.read(buff);
                        buff.flip();
                        JIperfClient.this.queueToSend.put(buff);
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Filling task got exc", t);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Throwable throwable) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

