/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.jiperf.control;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import lia.util.net.jiperf.control.StreamConsumer;

public class StreamPumper
implements Runnable {
    private static final int SIZE = 1024;
    private BufferedReader in;
    private StreamConsumer consumer = null;
    private PrintWriter out = new PrintWriter(System.out);

    public StreamPumper(InputStream in, PrintWriter writer) {
        this(in);
        this.out = writer;
    }

    public StreamPumper(InputStream in) {
        this.in = new BufferedReader(new InputStreamReader(in), 1024);
    }

    public StreamPumper(InputStream in, StreamConsumer consumer) {
        this(in);
        this.consumer = consumer;
    }

    public StreamPumper(InputStream in, PrintWriter writer, StreamConsumer consumer) {
        this(in);
        this.out = writer;
        this.consumer = consumer;
    }

    @Override
    public void run() {
        try {
            String s = this.in.readLine();
            while (s != null) {
                this.consumeLine(s);
                if (this.out != null) {
                    this.out.println(s);
                    this.out.println("<DONE>");
                    this.out.flush();
                }
                s = this.in.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.flush();
        this.out.close();
    }

    private void consumeLine(String line) {
        if (this.consumer != null) {
            this.consumer.consumeLine(line);
        }
    }
}

