/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.jiperf.test;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lia.util.net.common.Config;
import lia.util.net.common.Utils;

public class FDTNetPerf {
    private static final ExecutorService execThPool = Utils.getStandardExecService("ExecService", 3, 100, 10);
    private static final ScheduledThreadPoolExecutor monitorThPool = Utils.getSchedExecService("MonitorService", 1, 1);
    private static int port = 54320;
    private static AtomicLong totalBytes = new AtomicLong(0L);
    private static int byteBufferSize = 524288;
    private static int buffCount = 1;

    private FDTNetPerf(Map<String, Object> argsMap) throws Exception {
        monitorThPool.scheduleWithFixedDelay(new FDTNetPerfMonitorTask(), 1L, 2L, TimeUnit.SECONDS);
        Object host = argsMap.get("-c");
        if (host != null) {
            execThPool.execute(new FDTNetPerfClient(host.toString(), port));
        } else {
            execThPool.execute(new FDTNetPerfServer());
        }
    }

    public static void main(String[] args) {
        Map<String, Object> argsMap = Utils.parseArguments(args, Config.SINGLE_CMDLINE_ARGS);
        byteBufferSize = Utils.getIntValue(argsMap, "-bs", byteBufferSize);
        buffCount = Utils.getIntValue(argsMap, "-bn", buffCount);
        port = Utils.getIntValue(argsMap, "-p", port);
        try {
            new FDTNetPerf(argsMap);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000000L);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private static class FDTNetPerfMonitorTask
    implements Runnable {
        private long lastCount;
        private long lastRun;

        private FDTNetPerfMonitorTask() {
        }

        @Override
        public void run() {
            long currentCount = totalBytes.get();
            long now = System.currentTimeMillis();
            if (this.lastRun > 0L) {
                long diff = currentCount - this.lastCount;
                double speed = (double)diff * 8.0 / (double)(now - this.lastRun);
                System.out.println(new Date() + " CurentSpeed: " + speed / 1000.0 + " Mb/s");
            }
            this.lastRun = now;
            this.lastCount = currentCount;
        }
    }

    private static class FDTNetPerfClient
    implements Runnable {
        SocketChannel sc;
        private ByteBuffer[] buffs;
        private boolean shouldWrite;

        private FDTNetPerfClient() throws Exception {
            int bCount = 0;
            ArrayList<ByteBuffer> buffsList = new ArrayList<ByteBuffer>(buffCount);
            try {
                for (int i = 0; i < buffCount; ++i) {
                    buffsList.add(ByteBuffer.allocateDirect(byteBufferSize));
                    ++bCount;
                }
            }
            catch (OutOfMemoryError oom) {
                System.out.println("Reached OOM while alocating buffers. Allocated " + bCount + " buffers");
            }
            if (bCount <= 0) {
                throw new Exception("Cannot instantiate the buff pool");
            }
            this.buffs = buffsList.toArray(new ByteBuffer[buffsList.size()]);
            System.out.println("buffs.size() = " + this.buffs.length * byteBufferSize / 1024 + " KB");
        }

        FDTNetPerfClient(String host, int port) throws Exception {
            this();
            this.sc = SocketChannel.open();
            this.sc.configureBlocking(true);
            this.sc.socket().connect(new InetSocketAddress(InetAddress.getByName(host), port));
            this.shouldWrite = true;
        }

        FDTNetPerfClient(SocketChannel sc) throws Exception {
            this();
            this.sc = sc;
            this.shouldWrite = false;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (this.shouldWrite) {
                        for (ByteBuffer buff : this.buffs) {
                            buff.position(0);
                            buff.limit(buff.capacity());
                        }
                        totalBytes.addAndGet(this.sc.write(this.buffs));
                        continue;
                    }
                    for (ByteBuffer buff : this.buffs) {
                        buff.clear();
                    }
                    totalBytes.addAndGet(this.sc.read(this.buffs));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
    }

    private static class FDTNetPerfServer
    implements Runnable {
        private ServerSocketChannel ssc = ServerSocketChannel.open();

        FDTNetPerfServer() throws Exception {
            this.ssc.configureBlocking(true);
            this.ssc.socket().bind(new InetSocketAddress(port));
        }

        @Override
        public void run() {
            try {
                SocketChannel sc = this.ssc.accept();
                sc.configureBlocking(true);
                execThPool.execute(new FDTNetPerfClient(sc));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

