/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.Marker;
import org.globus.ftp.exception.PerfMarkerException;

public class PerfMarker
implements Marker {
    private static Log logger = LogFactory.getLog(PerfMarker.class.getName());
    protected final String nl = System.getProperty("line.separator");
    protected static final int UNDEFINED = -1;
    protected boolean hasTimeStamp = false;
    protected double timeStamp = -1.0;
    protected boolean hasStripeIndex = false;
    protected long stripeIndex = -1L;
    protected boolean hasStripeBytesTransferred = false;
    protected long stripeBytesTransferred = -1L;
    protected boolean hasTotalStripeCount = false;
    protected long totalStripeCount = -1L;

    public PerfMarker(String msg) throws IllegalArgumentException {
        StringTokenizer tokens = new StringTokenizer(msg, this.nl);
        if (!tokens.nextToken().trim().equals("Perf Marker")) {
            this.badMsg("should start with Perf Marker'", msg);
        }
        if (!tokens.hasMoreTokens()) {
            this.badMsg("No parameters", msg);
        }
        while (tokens.hasMoreTokens()) {
            String name;
            StringTokenizer line = new StringTokenizer(tokens.nextToken(), ":");
            if (!line.hasMoreTokens()) {
                this.badMsg("one of lines empty", msg);
            }
            if (!(name = line.nextToken()).startsWith(" ")) {
                if (name.startsWith("112")) break;
                logger.debug("ending line: ->" + name + "<-");
                this.badMsg("No ending '112' line", msg);
                break;
            }
            name = name.trim();
            if (!line.hasMoreTokens()) {
                this.badMsg("one of parameters has no value", msg);
            }
            String value = line.nextToken().trim();
            if (name.equals("Timestamp")) {
                try {
                    this.timeStamp = Double.parseDouble(value);
                    this.hasTimeStamp = true;
                }
                catch (NumberFormatException e) {
                    this.badMsg("Not double value:" + value, msg);
                }
                continue;
            }
            if (name.equals("Stripe Index")) {
                try {
                    this.stripeIndex = Long.parseLong(value);
                    this.hasStripeIndex = true;
                }
                catch (NumberFormatException e) {
                    this.badMsg("Not long value:" + value, msg);
                }
                continue;
            }
            if (name.equals("Stripe Bytes Transferred")) {
                try {
                    this.stripeBytesTransferred = Long.parseLong(value);
                    this.hasStripeBytesTransferred = true;
                }
                catch (NumberFormatException e) {
                    this.badMsg("Not long value:" + value, msg);
                }
                continue;
            }
            if (!name.equals("Total Stripe Count")) continue;
            try {
                this.totalStripeCount = Long.parseLong(value);
                this.hasTotalStripeCount = true;
            }
            catch (NumberFormatException e) {
                this.badMsg("Not long value:" + value, msg);
            }
        }
        if (!this.hasTimeStamp) {
            this.badMsg("no timestamp", msg);
        }
    }

    private void badMsg(String why, String msg) {
        throw new IllegalArgumentException("argument is not FTP 112 reply message (" + why + ": ->" + msg + "<-");
    }

    public boolean hasStripeIndex() {
        return this.hasStripeIndex;
    }

    public boolean hasStripeBytesTransferred() {
        return this.hasStripeBytesTransferred;
    }

    public boolean hasTotalStripeCount() {
        return this.hasTotalStripeCount;
    }

    public double getTimeStamp() {
        return this.timeStamp;
    }

    public long getStripeIndex() throws PerfMarkerException {
        if (!this.hasStripeIndex) {
            throw new PerfMarkerException(1);
        }
        return this.stripeIndex;
    }

    public long getStripeBytesTransferred() throws PerfMarkerException {
        if (!this.hasStripeBytesTransferred) {
            throw new PerfMarkerException(1);
        }
        return this.stripeBytesTransferred;
    }

    public long getTotalStripeCount() throws PerfMarkerException {
        if (!this.hasTotalStripeCount) {
            throw new PerfMarkerException(1);
        }
        return this.totalStripeCount;
    }
}

