/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.HostPort;
import org.globus.ftp.Session;
import org.globus.ftp.dc.DataChannel;
import org.globus.ftp.dc.DataChannelFactory;
import org.globus.ftp.dc.SimpleSocketBox;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.Task;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;
import org.globus.net.SocketFactory;

public class ActiveConnectTask
extends Task {
    protected static Log logger = LogFactory.getLog(ActiveConnectTask.class.getName());
    protected HostPort hostPort;
    protected SocketBox mySocketBox;
    protected DataSink sink;
    protected DataSource source;
    protected BasicServerControlChannel control;
    protected Session session;
    protected DataChannelFactory factory;
    protected TransferContext context;

    public ActiveConnectTask(HostPort hostPort, DataSink sink, BasicServerControlChannel control, Session session, DataChannelFactory factory, TransferContext context) {
        this.sink = sink;
        this.init(hostPort, control, session, factory, context);
    }

    public ActiveConnectTask(HostPort hostPort, DataSource source, BasicServerControlChannel control, Session session, DataChannelFactory factory, TransferContext context) {
        this.source = source;
        this.init(hostPort, control, session, factory, context);
    }

    private void init(HostPort hostPort, BasicServerControlChannel control, Session session, DataChannelFactory factory, TransferContext context) {
        this.hostPort = hostPort;
        this.session = session;
        this.control = control;
        this.factory = factory;
        this.context = context;
    }

    public void execute() {
        block9: {
            try {
                DataChannel dataChannel = null;
                this.mySocketBox = null;
                try {
                    this.mySocketBox = this.openSocket();
                }
                catch (Exception e) {
                    FTPServerFacade.exceptionToControlChannel(e, "active connection failed", this.control);
                    return;
                }
                try {
                    dataChannel = this.factory.getDataChannel(this.session, this.mySocketBox);
                    if (this.sink != null) {
                        logger.debug("starting sink data channel");
                        dataChannel.startTransfer(this.sink, this.control, this.context);
                        break block9;
                    }
                    if (this.source != null) {
                        logger.debug("starting source data channel");
                        dataChannel.startTransfer(this.source, this.control, this.context);
                        break block9;
                    }
                    logger.error("not set");
                }
                catch (Exception e) {
                    FTPServerFacade.exceptionToControlChannel(e, "active connection to server failed", this.control);
                    if (dataChannel != null) {
                        dataChannel.close();
                    }
                }
            }
            catch (Exception e) {
                FTPServerFacade.cannotPropagateError(e);
            }
        }
    }

    protected SocketBox openSocket() throws Exception {
        SimpleSocketBox sBox = new SimpleSocketBox();
        SocketFactory factory = SocketFactory.getDefault();
        Socket mySocket = factory.createSocket(this.hostPort.getHost(), this.hostPort.getPort());
        sBox.setSocket(mySocket);
        return sBox;
    }

    private void close() {
    }

    public void stop() {
        this.close();
    }
}

