/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.HostPort;
import org.globus.ftp.Session;
import org.globus.ftp.dc.DataChannel;
import org.globus.ftp.dc.DataChannelFactory;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.Task;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;

public class ActiveStartTransferTask
extends Task {
    static Log logger = LogFactory.getLog(ActiveStartTransferTask.class.getName());
    HostPort hostPort;
    BasicServerControlChannel control;
    protected static final int STOR = 1;
    protected static final int RETR = 2;
    int operation;
    DataSink sink;
    DataSource source;
    SocketBox box;
    Session session;
    DataChannelFactory factory;
    TransferContext context;

    public ActiveStartTransferTask(DataSink sink, BasicServerControlChannel control, SocketBox box, Session session, DataChannelFactory factory, TransferContext context) {
        this.sink = sink;
        this.init(1, control, box, session, factory, context);
    }

    public ActiveStartTransferTask(DataSource source, BasicServerControlChannel control, SocketBox box, Session session, DataChannelFactory factory, TransferContext context) {
        this.source = source;
        this.init(2, control, box, session, factory, context);
    }

    private void init(int operation, BasicServerControlChannel control, SocketBox box, Session session, DataChannelFactory factory, TransferContext context) {
        if (box == null) {
            throw new IllegalArgumentException("Socket box is null");
        }
        if (control == null) {
            throw new IllegalArgumentException("Control channel is null");
        }
        this.factory = factory;
        this.session = session;
        this.operation = operation;
        this.control = control;
        this.box = box;
        this.context = context;
    }

    public void execute() {
        block6: {
            try {
                try {
                    if (this.box.getSocket() == null) {
                        throw new IllegalArgumentException("socket is null");
                    }
                    logger.debug("active start transfer task executing");
                    DataChannel dChannel = this.factory.getDataChannel(this.session, this.box);
                    if (this.operation == 1) {
                        dChannel.startTransfer(this.sink, this.control, this.context);
                        break block6;
                    }
                    dChannel.startTransfer(this.source, this.control, this.context);
                }
                catch (Exception e) {
                    FTPServerFacade.exceptionToControlChannel(e, "startTransfer() failed", this.control);
                }
            }
            catch (Exception e) {
                FTPServerFacade.cannotPropagateError(e);
            }
        }
    }
}

