/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.proxy.ext;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class ProxyPolicy
implements ASN1Encodable {
    public static final ASN1ObjectIdentifier IMPERSONATION = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.21.1");
    public static final ASN1ObjectIdentifier INDEPENDENT = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.21.2");
    public static final ASN1ObjectIdentifier LIMITED = new ASN1ObjectIdentifier("1.3.6.1.4.1.3536.1.1.1.9");
    private ASN1ObjectIdentifier policyLanguage;
    private DEROctetString policy;

    public ProxyPolicy(ASN1Sequence seq) {
        if (seq.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.policyLanguage = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        if (seq.size() > 1) {
            ASN1Encodable obj = seq.getObjectAt(1);
            if (obj instanceof DERTaggedObject) {
                obj = ((DERTaggedObject)obj).getObject();
            }
            this.policy = (DEROctetString)obj;
        }
        this.checkConstraints();
    }

    public ProxyPolicy(ASN1ObjectIdentifier policyLanguage, byte[] policy) {
        if (policyLanguage == null) {
            throw new IllegalArgumentException();
        }
        this.policyLanguage = policyLanguage;
        if (policy != null) {
            this.policy = new DEROctetString(policy);
        }
        this.checkConstraints();
    }

    public ProxyPolicy(String policyLanguageOid, byte[] policy) {
        if (policyLanguageOid == null) {
            throw new IllegalArgumentException();
        }
        this.policyLanguage = new ASN1ObjectIdentifier(policyLanguageOid);
        if (policy != null) {
            this.policy = new DEROctetString(policy);
        }
        this.checkConstraints();
    }

    public ProxyPolicy(ASN1ObjectIdentifier policyLanguage, String policy) {
        this(policyLanguage, policy != null ? policy.getBytes() : null);
    }

    public ProxyPolicy(ASN1ObjectIdentifier policyLanguage) {
        this(policyLanguage, (byte[])null);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add(this.policyLanguage);
        if (this.policy != null) {
            vec.add(this.policy);
        }
        return new DERSequence(vec);
    }

    protected void checkConstraints() {
        if ((this.policyLanguage.equals(IMPERSONATION) || this.policyLanguage.equals(INDEPENDENT)) && this.policy != null) {
            throw new IllegalArgumentException();
        }
    }

    public byte[] getPolicy() {
        return this.policy != null ? this.policy.getOctets() : new byte[]{};
    }

    public String getPolicyAsString() {
        return this.policy != null ? new String(this.policy.getOctets()) : null;
    }

    public ASN1ObjectIdentifier getPolicyLanguage() {
        return this.policyLanguage;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ProxyPolicy: ");
        buf.append(this.policyLanguage.getId());
        if (this.policy != null) {
            buf.append(System.getProperty("line.separator"));
            buf.append(this.getPolicyAsString());
        }
        return buf.toString();
    }
}

