/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.streams;

import java.io.IOException;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.exception.FTPException;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.io.streams.FTPOutputStream;
import org.ietf.jgss.GSSCredential;

public class GridFTPOutputStream
extends FTPOutputStream {
    public GridFTPOutputStream(GSSCredential cred, String host, int port, String file, boolean append) throws IOException, FTPException {
        this(cred, HostAuthorization.getInstance(), host, port, file, append, true, 1, true);
    }

    public GridFTPOutputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean append, boolean reqDCAU) throws IOException, FTPException {
        this(cred, auth, host, port, file, append, true, 1, reqDCAU);
    }

    public GridFTPOutputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean append, boolean reqDCAU, long size) throws IOException, FTPException {
        this(cred, auth, host, port, file, append, true, 1, reqDCAU, size);
    }

    public GridFTPOutputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean append, boolean passive, int type, boolean reqDCAU) throws IOException, FTPException {
        this(cred, auth, host, port, file, append, passive, type, reqDCAU, -1L);
    }

    public GridFTPOutputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean append, boolean passive, int type, boolean reqDCAU, long size) throws IOException, FTPException {
        GridFTPClient gridFtp = new GridFTPClient(host, port);
        try {
            gridFtp.setAuthorization(auth);
            gridFtp.authenticate(cred);
            if (gridFtp.isFeatureSupported("DCAU")) {
                if (!reqDCAU) {
                    gridFtp.setDataChannelAuthentication(DataChannelAuthentication.NONE);
                }
            } else {
                gridFtp.setLocalNoDataChannelAuthentication();
            }
            this.ftp = gridFtp;
            this.put(passive, type, file, append);
        }
        catch (IOException e) {
            gridFtp.close();
            throw e;
        }
        catch (FTPException e) {
            gridFtp.close();
            throw e;
        }
    }
}

