/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.globus.rsl.Binding;
import org.globus.rsl.NameValue;
import org.globus.rsl.RslEvaluationException;

public class Bindings
extends NameValue {
    public Bindings(String attribute) {
        super(attribute);
    }

    public void add(Binding binding) {
        if (this.values == null) {
            this.values = new LinkedList();
        }
        this.values.add(binding);
    }

    public boolean removeVariable(String varName) {
        if (this.values == null) {
            return false;
        }
        Iterator iter = this.values.iterator();
        int i = 0;
        int found = -1;
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            if (binding.getName().equals(varName)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found != -1) {
            this.values.remove(found);
            return true;
        }
        return false;
    }

    public Bindings evaluate(Map symbolTable) throws RslEvaluationException {
        if (symbolTable == null) {
            throw new IllegalArgumentException("Symbol table must be initialized.");
        }
        LinkedList<Binding> newValues = new LinkedList<Binding>();
        for (Object vl : this.values) {
            if (vl instanceof Binding) {
                Binding binding = ((Binding)vl).evaluate(symbolTable);
                symbolTable.put(binding.getName(), binding.getValue().getValue());
                newValues.add(binding);
                continue;
            }
            throw new RuntimeException("Invalid object in binding");
        }
        Bindings bind = new Bindings(this.getAttribute());
        bind.setValues(newValues);
        return bind;
    }

    public void toRSL(StringBuffer buf, boolean explicitConcat) {
        buf.append("( ");
        buf.append(this.getAttribute());
        buf.append(" = ");
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            binding.toRSL(buf, explicitConcat);
            if (!iterator.hasNext()) continue;
            buf.append(" ");
        }
        buf.append(" )");
    }
}

