/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.util;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;

public class Preconditions {
    public static String checkNotNullOrEmpty(String reference) {
        com.google.common.base.Preconditions.checkNotNull(reference);
        if (reference.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return reference;
    }

    public static String checkNotNullOrEmpty(String reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        com.google.common.base.Preconditions.checkNotNull(reference, errorMessageTemplate, errorMessageArgs);
        if (reference.isEmpty()) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    @VisibleForTesting
    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

