/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Authorization
extends DefaultHandler {
    private static final String AUTHORIZEDKEYS_ELEMENT = "AuthorizedKeys";
    private static final String KEY_ELEMENT = "Key";
    private ArrayList authorizedKeys = new ArrayList();

    public Authorization(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        this.authorizedKeys.clear();
        saxParser.parse(in, (DefaultHandler)new AuthorizedKeysSAXHandler());
    }

    public Authorization() {
    }

    public List getAuthorizedKeys() {
        return (List)this.authorizedKeys.clone();
    }

    public void addKey(String keyfile) {
        this.authorizedKeys.add(keyfile);
    }

    public String toString() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = xml + "<!-- SSHTools Public Key Authorization File -->\n";
        xml = xml + "<AuthorizedKeys>\n";
        xml = xml + "<!-- Enter authorized public key elements here -->\n";
        Iterator it = this.authorizedKeys.iterator();
        while (it.hasNext()) {
            xml = xml + "   <Key>" + it.next().toString() + "</" + KEY_ELEMENT + ">\n";
        }
        xml = xml + "</AuthorizedKeys>";
        return xml;
    }

    class AuthorizedKeysSAXHandler
    extends DefaultHandler {
        private String currentElement = null;

        AuthorizedKeysSAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
            if (this.currentElement == null) {
                if (!qname.equals(Authorization.AUTHORIZEDKEYS_ELEMENT)) {
                    throw new SAXException("Unexpected root element " + qname);
                }
            } else if (this.currentElement.equals(Authorization.AUTHORIZEDKEYS_ELEMENT)) {
                if (!qname.equals(Authorization.KEY_ELEMENT)) {
                    throw new SAXException("Unexpected element " + qname);
                }
            } else {
                throw new SAXException("Unexpected element " + qname);
            }
            this.currentElement = qname;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentElement != null && this.currentElement.equals(Authorization.KEY_ELEMENT)) {
                String key = new String(ch, start, length);
                Authorization.this.authorizedKeys.add(key);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qname) throws SAXException {
            if (this.currentElement != null) {
                if (!this.currentElement.equals(qname)) {
                    throw new SAXException("Unexpected end element found " + qname);
                }
                if (this.currentElement.equals(Authorization.KEY_ELEMENT)) {
                    this.currentElement = Authorization.AUTHORIZEDKEYS_ELEMENT;
                } else if (this.currentElement.equals(Authorization.AUTHORIZEDKEYS_ELEMENT)) {
                    this.currentElement = null;
                } else {
                    throw new SAXException("Unexpected end element " + qname);
                }
            }
        }
    }
}

